/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import java.util.Arrays;
import java.util.Locale;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import mekanism.common.integration.computer.IComputerIntegration;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OCDriver
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return IComputerIntegration.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IComputerIntegration) {
            return new OCManagedEnvironment((IComputerIntegration)tile);
        }
        return null;
    }

    public static class OCManagedEnvironment
    extends AbstractManagedEnvironment
    implements NamedBlock,
    ManagedPeripheral {
        public IComputerIntegration computerTile;
        public String name;

        public OCManagedEnvironment(IComputerIntegration tile) {
            this.computerTile = tile;
            this.name = tile.func_70005_c_().toLowerCase(Locale.ENGLISH).replace(" ", "_");
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.name, Visibility.Network).create());
        }

        public String[] methods() {
            return this.computerTile.getMethods();
        }

        public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            return this.computerTile.invoke(Arrays.asList(this.methods()).indexOf(method), args.toArray());
        }

        public int priority() {
            return 4;
        }

        public String preferredName() {
            return this.name;
        }
    }
}

