/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBoilerTab
extends GuiTabElementType<TileEntityBoilerCasing, BoilerTab> {
    public GuiBoilerTab(IGuiWrapper gui, TileEntityBoilerCasing tile, BoilerTab type, ResourceLocation def) {
        super(gui, tile, type, def);
    }

    public static enum BoilerTab implements TabType
    {
        MAIN("GuiGasesTab.png", 54, "gui.main"),
        STAT("GuiStatsTab.png", 55, "gui.stats");

        private final String description;
        private final String path;
        private final int guiId;

        private BoilerTab(String path, int id, String desc) {
            this.path = path;
            this.guiId = id;
            this.description = desc;
        }

        @Override
        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, this.path);
        }

        @Override
        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, this.guiId));
        }

        @Override
        public String getDesc() {
            return LangUtils.localize(this.description);
        }

        @Override
        public int getYPos() {
            return 6;
        }
    }
}

