/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.awt.Rectangle;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiElement {
    public static final Minecraft mc = Minecraft.func_71410_x();
    protected final ResourceLocation RESOURCE;
    protected final IGuiWrapper guiObj;
    protected final ResourceLocation defaultLocation;

    public GuiElement(ResourceLocation resource, IGuiWrapper gui, ResourceLocation def) {
        this.RESOURCE = resource;
        this.guiObj = gui;
        this.defaultLocation = def;
    }

    public void displayTooltip(String s, int xAxis, int yAxis) {
        this.guiObj.displayTooltip(s, xAxis, yAxis);
    }

    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
        this.guiObj.displayTooltips(list, xAxis, yAxis);
    }

    public void offsetX(int xSize) {
        if (this.guiObj instanceof GuiContainer) {
            ((GuiContainer)this.guiObj).field_146999_f += xSize;
        }
    }

    public void offsetY(int ySize) {
        if (this.guiObj instanceof GuiContainer) {
            ((GuiContainer)this.guiObj).field_147000_g += ySize;
        }
    }

    public void offsetLeft(int guiLeft) {
        if (this.guiObj instanceof GuiContainer) {
            ((GuiContainer)this.guiObj).field_147003_i += guiLeft;
        }
    }

    public void offsetTop(int guiTop) {
        if (this.guiObj instanceof GuiContainer) {
            ((GuiContainer)this.guiObj).field_147009_r += guiTop;
        }
    }

    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.getFontRenderer().func_78256_a(text);
        if (length <= maxX) {
            this.getFontRenderer().func_78276_b(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.getFontRenderer().func_78276_b(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            GlStateManager.func_179121_F();
        }
        MekanismRenderer.resetColor();
    }

    public FontRenderer getFontRenderer() {
        return this.guiObj.getFont();
    }

    public void mouseClickMove(int mouseX, int mouseY, int button, long ticks) {
    }

    public void mouseReleased(int x, int y, int type) {
    }

    public void mouseWheel(int x, int y, int delta) {
    }

    public abstract Rectangle4i getBounds(int var1, int var2);

    public abstract void renderBackground(int var1, int var2, int var3, int var4);

    public abstract void renderForeground(int var1, int var2);

    public abstract void preMouseClicked(int var1, int var2, int var3);

    public abstract void mouseClicked(int var1, int var2, int var3);

    protected boolean inBounds(int xAxis, int yAxis) {
        return false;
    }

    public static class Rectangle4i {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public Rectangle4i(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
    }

    public static interface IInfoHandler {
        public List<String> getInfo();
    }
}

