/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.Coord4D;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Chunk3D {
    public int dimensionId;
    public int x;
    public int z;

    public Chunk3D(int x, int z, int dimension) {
        this.x = x;
        this.z = z;
        this.dimensionId = dimension;
    }

    public Chunk3D(Entity entity) {
        this.x = (int)entity.field_70165_t >> 4;
        this.z = (int)entity.field_70161_v >> 4;
        this.dimensionId = entity.field_71093_bK;
    }

    public Chunk3D(Coord4D coord) {
        this.x = coord.x >> 4;
        this.z = coord.z >> 4;
        this.dimensionId = coord.dimensionId;
    }

    public boolean exists(World world) {
        return world.func_72863_F().func_186026_b(this.x, this.z) != null;
    }

    public Chunk getChunk(World world) {
        return world.func_72964_e(this.x, this.z);
    }

    public ChunkPos getPos() {
        return new ChunkPos(this.x, this.z);
    }

    public Chunk3D clone() {
        return new Chunk3D(this.x, this.z, this.dimensionId);
    }

    public String toString() {
        return "[Chunk3D: " + this.x + ", " + this.z + ", dim=" + this.dimensionId + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Chunk3D && ((Chunk3D)obj).x == this.x && ((Chunk3D)obj).z == this.z && ((Chunk3D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.x;
        code = 31 * code + this.z;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

