/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.api.misc.IDisableableItem;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.util.AwfulUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;

public final class StackUtil {
    public static boolean isValid(ItemStack stack) {
        Item i;
        if (stack == null) {
            AwfulUtil.callTheFuckinPolice("Null ItemStack detected", stack);
        }
        if ((i = stack.func_77973_b()) instanceof IDisableableItem) {
            return !((IDisableableItem)i).isDisabled();
        }
        return !stack.func_190926_b();
    }

    public static ItemStack getEmpty() {
        return ItemStack.field_190927_a;
    }

    public static NonNullList<ItemStack> makeList(int size) {
        return NonNullList.func_191197_a((int)size, (Object)StackUtil.getEmpty());
    }

    public static boolean isEmpty(Collection<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return true;
        }
        for (ItemStack s : stacks) {
            if (s.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean canAddAll(ItemStackHandlerAA inv, List<ItemStack> stacks, boolean fromAutomation) {
        int counter = 0;
        ItemStackHandlerAA dummy = StackUtil.testDummy(inv, 0, inv.getSlots());
        for (ItemStack s : stacks) {
            for (int i = 0; i < dummy.getSlots() && !(s = dummy.insertItem(i, s, false, fromAutomation)).func_190926_b(); ++i) {
            }
            if (!s.func_190926_b()) continue;
            ++counter;
        }
        return counter == stacks.size();
    }

    public static void addAll(ItemStackHandlerAA inv, List<ItemStack> stacks, boolean fromAutomation) {
        int slotMax = inv.getSlots();
        for (ItemStack s : stacks) {
            for (int i = 0; i < slotMax && !(s = inv.insertItem(i, s, false, fromAutomation)).func_190926_b(); ++i) {
            }
        }
    }

    public static boolean canAddAll(ItemStackHandlerAA inv, List<ItemStack> stacks, int slot, int endSlot, boolean fromAutomation) {
        int counter = 0;
        ItemStackHandlerAA dummy = StackUtil.testDummy(inv, slot, endSlot);
        for (ItemStack s : stacks) {
            for (int i = 0; i < dummy.getSlots() && !(s = dummy.insertItem(i, s, false, fromAutomation)).func_190926_b(); ++i) {
            }
            if (!s.func_190926_b()) continue;
            ++counter;
        }
        return counter == stacks.size();
    }

    public static void addAll(ItemStackHandlerAA inv, List<ItemStack> stacks, int slot, int endSlot, boolean fromAutomation) {
        for (ItemStack s : stacks) {
            for (int i = slot; i < endSlot && !(s = inv.insertItem(i, s, false, fromAutomation)).func_190926_b(); ++i) {
            }
        }
    }

    public static int findFirstFilled(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack grow(ItemStack s, int i) {
        s.func_190917_f(i);
        return s;
    }

    public static ItemStack shrink(ItemStack s, int i) {
        s.func_190918_g(i);
        return s;
    }

    public static ItemStack shrinkForContainer(ItemStack s, int i) {
        ItemStack sc = s.func_77946_l();
        s.func_190918_g(i);
        if (s.func_190926_b()) {
            return sc.func_77973_b().getContainerItem(sc);
        }
        return s;
    }

    public static ItemStack insertItem(SlotlessableItemHandlerWrapper wrapper, ItemStack stack, boolean simulate, int slotStart, int slotEnd) {
        Object handler;
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack remain = stack.func_77946_l();
        if (ActuallyAdditions.commonCapsLoaded && (handler = wrapper.getSlotlessHandler()) instanceof ISlotlessItemHandler && !ItemStack.func_77989_b((ItemStack)(remain = ((ISlotlessItemHandler)handler).insertItem(remain, simulate)), (ItemStack)stack)) {
            return remain;
        }
        handler = wrapper.getNormalHandler();
        if (handler != null) {
            for (int i = Math.max(0, slotStart); i < Math.min(slotEnd, handler.getSlots()); ++i) {
                remain = handler.insertItem(i, remain, simulate);
            }
        }
        return remain;
    }

    public static ItemStackHandlerAA testDummy(ItemStackHandlerAA inv, int slot, int endSlot) {
        NonNullList stacks = NonNullList.func_191197_a((int)(endSlot - slot), (Object)StackUtil.getEmpty());
        for (int i = slot; i < endSlot; ++i) {
            stacks.set(i - slot, (Object)inv.getStackInSlot(i).func_77946_l());
        }
        return new ItemStackHandlerAA((NonNullList<ItemStack>)stacks, inv.getAcceptor(), inv.getRemover());
    }
}

