/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.particle.ParticleBeam;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class AssetUtil {
    public static final int MAX_LIGHT_X = 0xF000F0;
    public static final int MAX_LIGHT_Y = 0xF000F0;
    public static final ResourceLocation GUI_INVENTORY_LOCATION = AssetUtil.getGuiLocation("gui_inventory");

    public static ResourceLocation getGuiLocation(String file) {
        return new ResourceLocation("actuallyadditions", "textures/gui/" + file + ".png");
    }

    public static ResourceLocation getBookletGuiLocation(String file) {
        return AssetUtil.getGuiLocation("booklet/" + file);
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayNameString(FontRenderer font, int xSize, int yPositionOfMachineText, String text) {
        font.func_78276_b(text, xSize / 2 - font.func_78256_a(text) / 2, yPositionOfMachineText, 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayNameString(FontRenderer font, int xSize, int yPositionOfMachineText, TileEntityBase tile) {
        AssetUtil.displayNameString(font, xSize, yPositionOfMachineText, StringUtil.localize(tile.getNameForTranslation()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlockInWorld(Block block, int meta) {
        AssetUtil.renderItemInWorld(new ItemStack(block, 1, meta));
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemInWorld(ItemStack stack) {
        if (StackUtil.isValid(stack)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderStateInWorld(IBlockState state, IBlockAccess world, BlockPos pos, float brightness) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, world, pos, 0);
        float r = (float)(i >> 16 & 0xFF) / 255.0f;
        float g = (float)(i >> 8 & 0xFF) / 255.0f;
        float b = (float)(i & 0xFF) / 255.0f;
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_187495_a(state, model, brightness, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemWithoutScrewingWithColors(ItemStack stack) {
        if (StackUtil.isValid(stack)) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderItem renderer = mc.func_175599_af();
            TextureManager manager = mc.func_110434_K();
            IBakedModel model = renderer.func_184393_a(stack, null, null);
            manager.func_110577_a(TextureMap.field_110575_b);
            manager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED, (boolean)false);
            renderer.func_180454_a(stack, model);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            manager.func_110577_a(TextureMap.field_110575_b);
            manager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderStackToGui(ItemStack stack, int x, int y, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        Minecraft mc = Minecraft.func_71410_x();
        boolean flagBefore = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(false);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(mc.field_71466_p, stack, 0, 0, null);
        mc.field_71466_p.func_78264_a(flagBefore);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        renderer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        renderer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        renderer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderNameTag(String tag, double x, double y, double z) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        int i = 0;
        int j = fontrenderer.func_78256_a(tag) / 2;
        GlStateManager.func_179090_x();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        renderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        renderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        renderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(tag, -fontrenderer.func_78256_a(tag) / 2, i, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(tag, -fontrenderer.func_78256_a(tag) / 2, i, -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void spawnLaserWithTimeServer(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, float[] color, int maxAge, double rotationTime, float size, float alpha) {
        if (!world.field_72995_K) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74780_a("StartX", startX);
            data.func_74780_a("StartY", startY);
            data.func_74780_a("StartZ", startZ);
            data.func_74780_a("EndX", endX);
            data.func_74780_a("EndY", endY);
            data.func_74780_a("EndZ", endZ);
            data.func_74776_a("Color1", color[0]);
            data.func_74776_a("Color2", color[1]);
            data.func_74776_a("Color3", color[2]);
            data.func_74780_a("RotationTime", rotationTime);
            data.func_74776_a("Size", size);
            data.func_74768_a("MaxAge", maxAge);
            data.func_74776_a("Alpha", alpha);
            PacketHandler.theNetwork.sendToAllAround((IMessage)new PacketServerToClient(data, PacketHandler.LASER_HANDLER), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), startX, startY, startZ, 96.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnLaserWithTimeClient(double startX, double startY, double startZ, double endX, double endY, double endZ, float[] color, int maxAge, double rotationTime, float size, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_70011_f(startX, startY, startZ) <= 64.0 || mc.field_71439_g.func_70011_f(endX, endY, endZ) <= 64.0) {
            ParticleBeam fx = new ParticleBeam((World)mc.field_71441_e, startX, startY, startZ, endX, endY, endZ, color, maxAge, rotationTime, size, alpha);
            mc.field_71452_i.func_78873_a((Particle)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderLaser(double firstX, double firstY, double firstZ, double secondX, double secondY, double secondZ, double rotationTime, float alpha, double beamWidth, float[] color) {
        Tessellator tessy = Tessellator.func_178181_a();
        BufferBuilder render = tessy.func_178180_c();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Vec3d vec1 = new Vec3d(firstX, firstY, firstZ);
        Vec3d vec2 = new Vec3d(secondX, secondY, secondZ);
        Vec3d combinedVec = vec2.func_178788_d(vec1);
        double rot = rotationTime > 0.0 ? 360.0 * ((double)world.func_82737_E() % rotationTime / rotationTime) : 0.0;
        double pitch = Math.atan2(combinedVec.field_72448_b, Math.sqrt(combinedVec.field_72450_a * combinedVec.field_72450_a + combinedVec.field_72449_c * combinedVec.field_72449_c));
        double yaw = Math.atan2(-combinedVec.field_72449_c, combinedVec.field_72450_a);
        double length = combinedVec.func_72433_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        int func = GL11.glGetInteger((int)3009);
        float ref = GL11.glGetFloat((int)3010);
        GlStateManager.func_179092_a((int)519, (float)0.0f);
        GlStateManager.func_179137_b((double)(firstX - TileEntityRendererDispatcher.field_147554_b), (double)(firstY - TileEntityRendererDispatcher.field_147555_c), (double)(firstZ - TileEntityRendererDispatcher.field_147552_d));
        GlStateManager.func_179114_b((float)((float)(180.0 * yaw / Math.PI)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(180.0 * pitch / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)rot), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        render.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        for (double i = 0.0; i < 4.0; i += 1.0) {
            double width = beamWidth * (i / 4.0);
            render.func_181662_b(length, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(0.0, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            render.func_181662_b(length, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
        }
        tessy.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179092_a((int)func, (float)ref);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static float[] getWheelColor(float pos) {
        if (pos < 85.0f) {
            return new float[]{pos * 3.0f, 255.0f - pos * 3.0f, 0.0f};
        }
        if (pos < 170.0f) {
            return new float[]{255.0f - (pos -= 85.0f) * 3.0f, 0.0f, pos * 3.0f};
        }
        return new float[]{0.0f, (pos -= 170.0f) * 3.0f, 255.0f - pos * 3.0f};
    }
}

