/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;

public class DefaultFarmerBehavior
implements IFarmerBehavior {
    private static ItemStack hoe = ItemStack.field_190927_a;

    public static boolean defaultPlant(World world, BlockPos pos, IBlockState toPlant, IFarmer farmer, int use) {
        if (toPlant != null) {
            BlockPos farmland = pos.func_177977_b();
            Block farmlandBlock = world.func_180495_p(farmland).func_177230_c();
            if (farmlandBlock instanceof BlockDirt || farmlandBlock instanceof BlockGrass) {
                world.func_175698_g(pos);
                DefaultFarmerBehavior.useHoeAt(world, farmland);
                world.func_184133_a(null, farmland, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                farmer.extractEnergy(use);
            }
            if (DefaultFarmerBehavior.tryPlant(toPlant, world, pos)) {
                farmer.extractEnergy(use);
                return true;
            }
        }
        return false;
    }

    private static boolean tryPlant(IBlockState toPlant, World world, BlockPos pos) {
        if (toPlant.func_177230_c().func_176196_c(world, pos)) {
            world.func_175656_a(pos, toPlant);
            return true;
        }
        return false;
    }

    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, World world, BlockPos pos, IFarmer farmer) {
        int use = 350;
        if (farmer.getEnergy() >= use * 2 && DefaultFarmerBehavior.defaultPlant(world, pos, this.getPlantablePlantFromStack(seed, world, pos), farmer, use)) {
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(World world, BlockPos pos, IFarmer farmer) {
        IBlockState state;
        Block block;
        int use = 250;
        if (farmer.getEnergy() >= use && ((block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof BlockCrops ? ((BlockCrops)block).func_185525_y(state) : BlockCrops.field_176488_a.equals((Object)block.func_176194_O().func_185920_a("age")) && (Integer)state.func_177229_b((IProperty)BlockCrops.field_176488_a) >= 7 && !(block instanceof BlockStem))) {
            return this.doFarmerStuff(state, world, pos, farmer);
        }
        return FarmerResult.FAIL;
    }

    private FarmerResult doFarmerStuff(IBlockState state, World world, BlockPos pos, IFarmer farmer) {
        ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
        ArrayList<ItemStack> other = new ArrayList<ItemStack>();
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
        for (ItemStack stack : drops) {
            if (this.getPlantableFromStack(stack) != null) {
                seeds.add(stack);
                continue;
            }
            other.add(stack);
        }
        boolean addSeeds = true;
        if (!farmer.canAddToSeeds(seeds)) {
            other.addAll(seeds);
            addSeeds = false;
        }
        if (farmer.canAddToOutput(other)) {
            farmer.addToOutput(other);
            if (addSeeds) {
                farmer.addToSeeds(seeds);
            }
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            world.func_175698_g(pos);
            farmer.extractEnergy(250);
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private IBlockState getPlantablePlantFromStack(ItemStack stack, World world, BlockPos pos) {
        IBlockState state;
        IPlantable plantable;
        if (StackUtil.isValid(stack) && (plantable = this.getPlantableFromStack(stack)) != null && (state = plantable.getPlant((IBlockAccess)world, pos)) != null && state.func_177230_c() instanceof IGrowable) {
            return state;
        }
        return null;
    }

    private IPlantable getPlantableFromStack(ItemStack stack) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof IPlantable) {
            return (IPlantable)item;
        }
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof IPlantable) {
            return (IPlantable)block;
        }
        return null;
    }

    private static ItemStack getHoeStack() {
        if (hoe.func_190926_b()) {
            hoe = new ItemStack(Items.field_151012_L);
        }
        return hoe;
    }

    public static EnumActionResult useHoeAt(World world, BlockPos pos) {
        FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        ItemStack itemstack = DefaultFarmerBehavior.getHoeStack();
        if (!player.func_175151_a(pos.func_177972_a(EnumFacing.UP), EnumFacing.UP, itemstack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)itemstack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.PASS;
    }
}

