/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CactusFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, World world, BlockPos pos, IFarmer farmer) {
        Block block;
        Item item;
        int use = 250;
        if (farmer.getEnergy() >= use && (item = seed.func_77973_b()) instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof BlockCactus) {
            if (block.func_176196_c(world, pos)) {
                IBlockState state = block.func_176223_P();
                world.func_180501_a(pos, state, 2);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                farmer.extractEnergy(use);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.FAIL;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(World world, BlockPos pos, IFarmer farmer) {
        IBlockState state;
        int use = 250;
        if (farmer.getEnergy() >= use && (state = world.func_180495_p(pos)).func_177230_c() instanceof BlockCactus) {
            FarmerResult result = FarmerResult.STOP_PROCESSING;
            for (int i = 2; i >= 1; --i) {
                BlockPos up;
                IBlockState upState;
                if (farmer.getEnergy() < use || !((upState = world.func_180495_p(up = pos.func_177981_b(i))).func_177230_c() instanceof BlockCactus)) continue;
                NonNullList drops = NonNullList.func_191196_a();
                upState.func_177230_c().getDrops(drops, (IBlockAccess)world, up, upState, 0);
                if (drops.isEmpty() || !farmer.canAddToOutput((List<ItemStack>)drops)) continue;
                world.func_175718_b(2001, up, Block.func_176210_f((IBlockState)upState));
                world.func_175698_g(up);
                farmer.extractEnergy(use);
                farmer.addToOutput((List<ItemStack>)drops);
                result = FarmerResult.SUCCESS;
            }
            return result;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 4;
    }
}

