/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.booklet.internal.GuiBookletBase;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPage;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageLinkButton;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageTextOnly;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageTrials
extends BookletPage {
    private final int buttonId;
    @SideOnly(value=Side.CLIENT)
    private GuiButton button;

    public PageTrials(int localizationKey, boolean button, boolean text) {
        super(localizationKey);
        if (!text) {
            this.setNoText();
        }
        this.buttonId = button ? PageLinkButton.nextButtonId++ : -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiBookletBase gui, int startX, int startY) {
        super.initGui(gui, startX, startY);
        if (this.buttonId >= 0) {
            this.button = new GuiButton(this.buttonId, startX + 62 - 50, startY + 120, 100, 20, "");
            gui.getButtonList().add(this.button);
            this.updateButton();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreenPre(GuiBookletBase gui, int startX, int startY, int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(gui, startX, startY, mouseX, mouseY, partialTicks);
        PageTextOnly.renderTextToPage(gui, this, startX + 6, startY + 5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String getLocalizationKey() {
        return "booklet.actuallyadditions.trials." + this.chapter.getIdentifier() + ".text." + this.localizationKey;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(GuiBookletBase gui, GuiButton button) {
        if (this.buttonId >= 0 && button.field_146127_k == this.buttonId) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)player);
            String id = this.chapter.getIdentifier();
            boolean completed = data.completedTrials.contains(id);
            if (completed) {
                data.completedTrials.remove(id);
            } else {
                data.completedTrials.add(id);
            }
            this.updateButton();
            PacketHandlerHelper.sendPlayerDataToServer(false, 2);
        } else {
            super.actionPerformed(gui, button);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateButton() {
        if (this.buttonId >= 0 && this.button != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)player);
            boolean completed = data.completedTrials.contains(this.chapter.getIdentifier());
            this.button.field_146126_j = completed ? TextFormatting.DARK_GREEN + StringUtil.localize("booklet.actuallyadditions.trialFinishButton.completed.name") : TextFormatting.DARK_RED + StringUtil.localize("booklet.actuallyadditions.trialFinishButton.uncompleted.name");
        }
    }
}

