/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiPage;
import de.ellpeck.actuallyadditions.mod.booklet.misc.BookletUtils;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDisplay {
    public final int x;
    public final int y;
    public final float scale;
    private final GuiPage gui;
    private final IBookletPage page;
    public ItemStack stack;

    public ItemDisplay(GuiPage gui, int x, int y, float scale, ItemStack stack, boolean shouldTryTransfer) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.stack = stack;
        this.page = shouldTryTransfer ? BookletUtils.findFirstPageForStack(stack) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPre() {
        AssetUtil.renderStackToGui(this.stack, this.x, this.y, this.scale);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPost(int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            Minecraft mc = this.gui.field_146297_k;
            boolean flagBefore = mc.field_71466_p.func_82883_a();
            mc.field_71466_p.func_78264_a(false);
            List list = this.stack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, this.stack.func_77953_t().field_77937_e + (String)list.get(k));
                    continue;
                }
                list.set(k, TextFormatting.GRAY + (String)list.get(k));
            }
            if (this.page != null && this.page != this.gui.pages[0] && this.page != this.gui.pages[1]) {
                list.add(TextFormatting.GOLD + StringUtil.localize("booklet.actuallyadditions.clickToSeeRecipe"));
            }
            GuiUtils.drawHoveringText((List)list, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
            mc.field_71466_p.func_78264_a(flagBefore);
        }
    }

    public void onMousePress(int button, int mouseX, int mouseY) {
        if (button == 0 && this.isHovered(mouseX, mouseY) && this.page != null && this.page != this.gui.pages[0] && this.page != this.gui.pages[1]) {
            this.gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            GuiPage gui = BookletUtils.createPageGui(this.gui.previousScreen, this.gui, this.page);
            this.gui.field_146297_k.func_147108_a((GuiScreen)gui);
        }
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && (float)mouseX < (float)this.x + 16.0f * this.scale && (float)mouseY < (float)this.y + 16.0f * this.scale;
    }
}

