/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.items;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.util.IConfigManager;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import baubles.api.BaubleType;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.client.IBaubleRender;
import p455w0rd.ae2wtlib.client.render.ItemLayerWrapper;
import p455w0rd.ae2wtlib.client.render.RenderLayerWT;
import p455w0rd.ae2wtlib.init.LibConfig;
import p455w0rd.ae2wtlib.init.LibNetworking;
import p455w0rd.ae2wtlib.sync.packets.PacketSetInRange;

public abstract class ItemWT
extends AEBasePoweredItem
implements ICustomWirelessTerminalItem {
    private EntityPlayer player;
    @SideOnly(value=Side.CLIENT)
    ItemLayerWrapper wrappedModel;

    protected ItemWT(ResourceLocation registryName) {
        super((double)LibConfig.WT_MAX_POWER);
        this.setRegistryName(registryName);
        this.func_77655_b(registryName.toString());
        this.func_77625_d(1);
    }

    protected EntityPlayer getPlayer() {
        return this.player;
    }

    protected void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    protected int getSlotFor(InventoryPlayer inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || !this.stackEqualExact(stack, inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack is) {
        double aeMaxPower;
        double aeCurrPower = this.getAECurrentPower(is);
        if ((int)aeCurrPower >= (int)(aeMaxPower = this.getAEMaxPower(is)) - 2) {
            return false;
        }
        return !WTApi.instance().isWTCreative(is);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    public ModelResourceLocation getModelResource() {
        return new ModelResourceLocation(this.getRegistryName(), "inventory");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemLayerWrapper getWrappedModel() {
        return this.wrappedModel;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setWrappedModel(ItemLayerWrapper wrappedModel) {
        this.wrappedModel = wrappedModel;
    }

    @Override
    public boolean shouldUseInternalTEISR() {
        return true;
    }

    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData((ItemStack)target).func_74737_b());
        return out;
    }

    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        return tag.func_74779_i("encryptionKey");
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }

    public boolean canHandle(ItemStack is) {
        return is.func_77973_b() == this;
    }

    private double injectPower(PowerUnits inputUnit, ItemStack is, double amount, boolean simulate) {
        if (simulate) {
            int requiredExt = (int)PowerUnits.AE.convertTo(inputUnit, this.getAEMaxPower(is) - this.getAECurrentPower(is));
            if (amount < (double)requiredExt) {
                return 0.0;
            }
            return amount - (double)requiredExt;
        }
        double powerRemainder = this.injectAEPower(is, inputUnit.convertTo(PowerUnits.AE, amount), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return PowerUnits.AE.convertTo(inputUnit, powerRemainder);
    }

    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(is);
        double currentStorage = this.getAECurrentPower(is);
        double required = maxStorage - currentStorage;
        double overflow = Math.min(amount * 2.0 - required, amount - required);
        if (mode == Actionable.MODULATE) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            double toAdd = Math.min(amount * 2.0, required);
            data.func_74780_a("internalCurrentPower", currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack is, int maxReceive, boolean simulate) {
        return maxReceive - (int)this.injectPower(PowerUnits.RF, is, maxReceive, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(is));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(is));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack is) {
        if (WTApi.instance().isWTCreative(is)) {
            return true;
        }
        if (LibConfig.USE_OLD_INFINTY_MECHANIC) {
            return this.checkForBooster(is);
        }
        return this.getEncryptionKey(is) != null && !this.getEncryptionKey(is).isEmpty() && WTApi.instance().hasInfiniteRange(is) && !WTApi.instance().isInRange(is);
    }

    public void func_77663_a(ItemStack wirelessTerminal, World w, Entity e, int i, boolean f) {
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e;
        if (this.getPlayer() == null) {
            this.setPlayer(p);
        }
        if (wirelessTerminal == null || !(wirelessTerminal.func_77973_b() instanceof ICustomWirelessTerminalItem)) {
            return;
        }
        if (p instanceof EntityPlayerMP) {
            this.rangeCheck(wirelessTerminal, (EntityPlayerMP)p);
        }
        WTApi.instance().isBoosterInstalled(wirelessTerminal);
    }

    private void rangeCheck(ItemStack wirelessTerm, EntityPlayerMP player) {
        boolean inRange = WTApi.instance().isInRangeOfWAP(wirelessTerm, (EntityPlayer)player);
        WTApi.instance().setInRange(wirelessTerm, inRange);
        LibNetworking.instance().sendTo(new PacketSetInRange(inRange), player);
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    @Override
    public IBaubleRender getRender() {
        return RenderLayerWT.getInstance();
    }

    @Override
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase playerIn) {
        if (playerIn instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)playerIn;
            this.rangeCheck(itemstack, player);
        }
    }
}

