/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.compat.EnergySupportDraconic;
import mcjty.lib.compat.EnergySupportEnderIO;
import mcjty.lib.compat.EnergySupportMekanism;
import mcjty.lib.compat.TeslaCompatibility;
import mcjty.lib.varia.IEnergyItem;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;

public class EnergyTools {
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> TESLA_HOLDER = null;
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> TESLA_CONSUMER = null;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> TESLA_PRODUCER = null;
    private static boolean draconic = false;
    private static boolean mekanism = false;
    private static boolean enderio = false;
    private static boolean checkMods = true;

    public static boolean isEnergyTE(TileEntity te, @Nullable EnumFacing side) {
        if (te == null) {
            return false;
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(te, side)) {
            return true;
        }
        return te.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    public static boolean isEnergyItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IEnergyItem) {
            return true;
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyItem(stack)) {
            return true;
        }
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    private static void doCheckMods() {
        if (checkMods) {
            draconic = Loader.isModLoaded((String)"draconicevolution");
            mekanism = Loader.isModLoaded((String)"mekanism");
            enderio = Loader.isModLoaded((String)"enderio");
            checkMods = false;
        }
    }

    public static EnergyLevel getEnergyLevelMulti(TileEntity tileEntity, @Nullable EnumFacing side) {
        long energyStored;
        long maxEnergyStored;
        EnergyTools.doCheckMods();
        if (tileEntity instanceof IBigPower) {
            maxEnergyStored = ((IBigPower)tileEntity).getCapacity();
            energyStored = ((IBigPower)tileEntity).getStoredPower();
        } else if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(tileEntity, side)) {
            maxEnergyStored = TeslaCompatibility.getMaxEnergy(tileEntity, side);
            energyStored = TeslaCompatibility.getEnergy(tileEntity, side);
        } else if (draconic && EnergySupportDraconic.isDraconicEnergyTile(tileEntity)) {
            maxEnergyStored = EnergySupportDraconic.getMaxEnergy(tileEntity);
            energyStored = EnergySupportDraconic.getCurrentEnergy(tileEntity);
        } else if (mekanism && EnergySupportMekanism.isMekanismTileEntity(tileEntity)) {
            maxEnergyStored = EnergySupportMekanism.getMaxEnergy(tileEntity);
            energyStored = EnergySupportMekanism.getCurrentEnergy(tileEntity);
        } else if (enderio && EnergySupportEnderIO.isEnderioTileEntity(tileEntity)) {
            maxEnergyStored = EnergySupportEnderIO.getMaxEnergy(tileEntity);
            energyStored = EnergySupportEnderIO.getCurrentEnergy(tileEntity);
        } else if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side);
            maxEnergyStored = energy.getMaxEnergyStored();
            energyStored = energy.getEnergyStored();
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(TileEntity tileEntity, @Nullable EnumFacing side) {
        long energyStored;
        long maxEnergyStored;
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(tileEntity, side)) {
            maxEnergyStored = TeslaCompatibility.getMaxEnergy(tileEntity, side);
            energyStored = TeslaCompatibility.getEnergy(tileEntity, side);
        } else if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side);
            maxEnergyStored = energy.getMaxEnergyStored();
            energyStored = energy.getEnergyStored();
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static long receiveEnergy(TileEntity tileEntity, EnumFacing from, long maxReceive) {
        IEnergyStorage capability;
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyReceiver(tileEntity, from)) {
            return TeslaCompatibility.receiveEnergy(tileEntity, from, maxReceive);
        }
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, from) && (capability = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, from)).canReceive()) {
            return capability.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false);
        }
        return 0L;
    }

    public static long receiveEnergy(ItemStack stack, long maxReceive) {
        IEnergyStorage capability;
        Item item = stack.func_77973_b();
        if (item instanceof IEnergyItem) {
            return ((IEnergyItem)item).receiveEnergyL(stack, maxReceive, false);
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyItem(stack)) {
            return TeslaCompatibility.receiveEnergy(stack, maxReceive, false);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (capability = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).canReceive()) {
            return capability.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false);
        }
        return 0L;
    }

    public static int unsignedClampToInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static int getIntEnergyStored(long energyStored, long maxEnergyStored) {
        return EnergyTools.unsignedClampToInt(energyStored);
    }

    public static class EnergyLevel {
        private final long energy;
        private final long maxEnergy;

        public EnergyLevel(long energy, long maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public long getEnergy() {
            return this.energy;
        }

        public long getMaxEnergy() {
            return this.maxEnergy;
        }
    }
}

