/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.McJtyEnergyStorage;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EnergyTools;
import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(modid="tesla", iface="net.darkhax.tesla.api.ITeslaHolder")})
public class GenericEnergyStorageTileEntity
extends GenericTileEntity
implements IBigPower,
ITeslaHolder {
    public static final String CMD_GETENERGY = "getEnergy";
    public static final Key<Long> PARAM_ENERGY = new Key<Long>("energy", Type.LONG);
    protected McJtyEnergyStorage storage;
    private static long currentRF = 0L;
    private int requestRfDelay = 3;
    private final IEnergyStorage energyStorage = new IEnergyStorage(){
        private final boolean isReceiver;
        {
            this.isReceiver = GenericEnergyStorageTileEntity.this instanceof GenericEnergyReceiverTileEntity;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.isReceiver ? (int)GenericEnergyStorageTileEntity.this.storage.receiveEnergy(maxReceive, simulate) : 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return EnergyTools.getIntEnergyStored(GenericEnergyStorageTileEntity.this.storage.getEnergyStored(), GenericEnergyStorageTileEntity.this.storage.getMaxEnergyStored());
        }

        public int getMaxEnergyStored() {
            return EnergyTools.unsignedClampToInt(GenericEnergyStorageTileEntity.this.storage.getMaxEnergyStored());
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return this.isReceiver;
        }
    };

    public void modifyEnergyStored(long energy) {
        this.storage.modifyEnergyStored(energy);
    }

    public GenericEnergyStorageTileEntity(long maxEnergy, long maxReceive) {
        this.storage = new McJtyEnergyStorage(maxEnergy);
        this.storage.setMaxReceive(maxReceive);
    }

    public GenericEnergyStorageTileEntity(long maxEnergy, long maxReceive, long maxExtract) {
        this.storage = new McJtyEnergyStorage(maxEnergy);
        this.storage.setMaxReceive(maxReceive);
        this.storage.setMaxExtract(maxExtract);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }

    public static long getCurrentRF() {
        return currentRF;
    }

    public static void setCurrentRF(long currentRF) {
        GenericEnergyStorageTileEntity.currentRF = currentRF;
    }

    public void requestRfFromServer(String modid) {
        --this.requestRfDelay;
        if (this.requestRfDelay > 0) {
            return;
        }
        this.requestRfDelay = 3;
        this.requestDataFromServer(modid, CMD_GETENERGY, TypedMap.EMPTY);
    }

    @Override
    @Nullable
    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETENERGY.equals(command)) {
            return TypedMap.builder().put(PARAM_ENERGY, this.storage.getEnergyStored()).build();
        }
        return null;
    }

    @Override
    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GETENERGY.equals(command)) {
            GenericEnergyStorageTileEntity.setCurrentRF(result.get(PARAM_ENERGY));
            return true;
        }
        return false;
    }

    public int getEnergyStored() {
        return EnergyTools.getIntEnergyStored(this.storage.getEnergyStored(), this.storage.getMaxEnergyStored());
    }

    public int getMaxEnergyStored() {
        return EnergyTools.unsignedClampToInt(this.storage.getMaxEnergyStored());
    }

    @Override
    public long getStoredPower() {
        return this.storage.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_HOLDER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == EnergyTools.TESLA_HOLDER) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }
}

