/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AbstractServerCommandTyped
implements IMessage {
    protected BlockPos pos;
    protected Integer dimensionId;
    protected String command;
    protected TypedMap params;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        this.params = TypedMapTools.readArguments(buf);
        this.dimensionId = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        TypedMapTools.writeArguments(buf, this.params);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.dimensionId.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    protected AbstractServerCommandTyped() {
    }

    protected AbstractServerCommandTyped(BlockPos pos, String command, TypedMap args) {
        this.pos = pos;
        this.command = command;
        this.params = args;
    }
}

