/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.debugtools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.PacketDumpItemInfo;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

public class DumpItemNBT {
    public static String dumpItemNBT(@Nonnull ItemStack item, boolean verbose) {
        if (item.func_190926_b()) {
            return "<null>";
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
        jsonObject.add("meta", (JsonElement)new JsonPrimitive((Number)item.func_77952_i()));
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            if (verbose) {
                String nbtJson = tag.toString();
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(nbtJson);
                jsonObject.add("nbt", element);
            } else {
                JsonArray array = new JsonArray();
                for (String key : tag.func_150296_c()) {
                    array.add((JsonElement)new JsonPrimitive(key));
                }
                jsonObject.add("nbt", (JsonElement)array);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    public static void dumpHeldItem(@Nullable SimpleNetworkWrapper network, @Nonnull EntityPlayer player, boolean verbose) {
        ItemStack item = player.func_184614_ca();
        if (item.func_190926_b()) {
            return;
        }
        String output = DumpItemNBT.dumpItemNBT(item, verbose);
        Logging.getLogger().log(Level.INFO, "### Client side ###");
        Logging.getLogger().log(Level.INFO, output);
        if (network != null) {
            network.sendToServer((IMessage)new PacketDumpItemInfo(verbose));
        }
    }
}

