/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.lib.builder.InformationString;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.varia.OrientationTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="mcjty.lib.compat.waila.WailaInfoProvider", modid="waila"), @Optional.Interface(iface="mcjty.lib.compat.theoneprobe.TOPInfoProvider", modid="theoneprobe")})
public class BaseBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider {
    public static final IProperty<?>[] NONE_PROPERTIES = new IProperty[0];
    protected ModBase modBase;
    private boolean creative;
    private boolean nonopaque = false;
    private boolean nonfullcube = false;
    private InformationString informationString;
    private InformationString informationStringWithShift;
    public static final PropertyDirection FACING_HORIZ = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final IProperty<?>[] HORIZ_PROPERTIES = new IProperty[]{FACING_HORIZ};
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final IProperty<?>[] ROTATING_PROPERTIES = new IProperty[]{FACING};
    private static final Pattern COMPILE = Pattern.compile("@", 16);

    public BaseBlock(ModBase mod, Material material, String name, Function<Block, ItemBlock> itemBlockFactory) {
        super(material);
        this.modBase = mod;
        this.creative = false;
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c(mod.getModId() + "." + name);
        this.setRegistryName(name);
        McJtyRegister.registerLater((Block)this, mod, itemBlockFactory);
    }

    public BaseBlock setCreative(boolean creative) {
        this.creative = creative;
        return this;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public static Collection<IProperty<?>> getPropertyKeys(IBlockState state) {
        return state.func_177227_a();
    }

    public static boolean activateBlock(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return block.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public RotationType getRotationType() {
        return RotationType.ROTATION;
    }

    public void setInformationString(InformationString informationString) {
        this.informationString = informationString;
    }

    public void setInformationStringWithShift(InformationString informationStringWithShift) {
        this.informationStringWithShift = informationStringWithShift;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        InformationString i = this.informationString;
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            i = this.informationStringWithShift;
        }
        if (i != null) {
            BaseBlock.addLocalizedInformation(i, stack, tooltip);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return state.func_177226_a((IProperty)FACING_HORIZ, (Comparable)placer.func_174811_aO().func_176734_d());
            }
            case ROTATION: {
                return state.func_177226_a((IProperty)FACING, (Comparable)OrientationTools.getFacingFromEntity(pos, placer));
            }
        }
        return state;
    }

    protected EnumFacing getOrientation(BlockPos pos, EntityLivingBase entityLivingBase) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return OrientationTools.determineOrientationHoriz(entityLivingBase);
            }
            case ROTATION: {
                return OrientationTools.determineOrientation(pos, entityLivingBase);
            }
        }
        return null;
    }

    public EnumFacing getFrontDirection(IBlockState state) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return (EnumFacing)state.func_177229_b((IProperty)FACING_HORIZ);
            }
            case ROTATION: {
                return (EnumFacing)state.func_177229_b((IProperty)FACING);
            }
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getRightDirection(IBlockState state) {
        return this.getFrontDirection(state).func_176735_f();
    }

    public EnumFacing getLeftDirection(IBlockState state) {
        return this.getFrontDirection(state).func_176746_e();
    }

    public static EnumFacing getFrontDirection(RotationType metaUsage, IBlockState state) {
        switch (metaUsage) {
            case HORIZROTATION: {
                return OrientationTools.getOrientationHoriz(state);
            }
            case ROTATION: {
                return OrientationTools.getOrientation(state);
            }
        }
        return EnumFacing.SOUTH;
    }

    public IBlockState func_176203_a(int meta) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZ, (Comparable)EnumFacing.field_82609_l[meta + 2]);
            }
            case ROTATION: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta & 7]);
            }
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return ((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZ)).func_176745_a() - 2;
            }
            case ROTATION: {
                return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
            }
        }
        return 0;
    }

    protected IProperty<?>[] getProperties() {
        return BaseBlock.getProperties(this.getRotationType());
    }

    public static IProperty<?>[] getProperties(RotationType rotationType) {
        switch (rotationType) {
            case HORIZROTATION: {
                return HORIZ_PROPERTIES;
            }
            case ROTATION: {
                return ROTATING_PROPERTIES;
            }
        }
        return NONE_PROPERTIES;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, this.getProperties());
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.nonopaque;
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.nonfullcube;
    }

    public void setOpaqueCube(boolean opaque) {
        this.nonopaque = !opaque;
        this.field_149787_q = this.func_176223_P().func_185914_p();
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        this.field_149785_s = !this.field_149764_J.func_76228_b();
    }

    public void setFullcube(boolean fullcube) {
        this.nonfullcube = !fullcube;
    }

    public void initModel() {
        McJtyLib.proxy.initStandardItemModel(this);
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
    }

    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public static void addLocalizedInformation(InformationString informationString, ItemStack stack, List<String> tooltip) {
        if (informationString != null) {
            Object[] parameters = new Object[informationString.getInformationStringParameters().size()];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = informationString.getInformationStringParameters().get(i).apply(stack);
            }
            String translated = I18n.func_135052_a((String)informationString.getString(), (Object[])parameters);
            translated = COMPILE.matcher(translated).replaceAll("\u00a7");
            Collections.addAll(tooltip, StringUtils.split((String)translated, (String)"\n"));
        }
    }

    public static enum RotationType {
        HORIZROTATION,
        ROTATION,
        NONE;

    }
}

