/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.proxy;

import java.io.File;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import mcjty.rftoolscontrol.CommandHandler;
import mcjty.rftoolscontrol.ForgeEventHandlers;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.ModBlocks;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.gui.GuiProxy;
import mcjty.rftoolscontrol.items.ModItems;
import mcjty.rftoolscontrol.logic.registry.Functions;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber
public abstract class CommonProxy
extends AbstractCommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        CommandHandler.registerCommands();
        this.mainConfig = new Configuration(new File(this.modConfigDir.getPath() + File.separator + "rftools", "control.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"rftoolscontrol", (String)"rftoolsctrl");
        RFToolsCtrlMessages.registerNetworkMessages(network);
        Opcodes.init();
        Functions.init();
        ModBlocks.init();
        ModItems.init();
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            GeneralConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RFToolsControl.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
    }
}

