/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.api.parameters.Tuple;
import mcjty.rftoolscontrol.logic.ParameterTools;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.registry.Functions;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ParameterTypeTools {
    public static String stringRepresentation(ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            return "V:" + value.getVariableIndex();
        }
        if (value.isFunction()) {
            return "F:" + value.getFunction().getName();
        }
        if (value.getValue() == null) {
            return "";
        }
        return ParameterTypeTools.stringRepresentationInternal(type, value.getValue());
    }

    private static String stringRepresentationInternal(ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                return (String)value;
            }
            case PAR_INTEGER: {
                return Integer.toString((Integer)value);
            }
            case PAR_LONG: {
                return Long.toString((Long)value);
            }
            case PAR_FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case PAR_NUMBER: {
                String s = TypeConverters.castNumberToString(value);
                return s + " (" + TypeConverters.getNumberType(value) + ")";
            }
            case PAR_SIDE: {
                return ((BlockSide)value).getStringRepresentation();
            }
            case PAR_BOOLEAN: {
                return (Boolean)value != false ? "true" : "false";
            }
            case PAR_INVENTORY: {
                return ((Inventory)value).getStringRepresentation();
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                return StringUtils.left((String)itemStack.func_82833_r(), (int)10);
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                return StringUtils.left((String)fluidStack.getLocalizedName(), (int)10);
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                return exception.getCode();
            }
            case PAR_TUPLE: {
                return value.toString();
            }
            case PAR_VECTOR: {
                return "[" + ((List)value).size() + "]";
            }
        }
        return "?";
    }

    public static JsonElement writeToJson(ParameterType type, ParameterValue value) {
        JsonObject jsonObject = new JsonObject();
        if (value.isVariable()) {
            jsonObject.add("var", (JsonElement)new JsonPrimitive((Number)value.getVariableIndex()));
        } else if (value.isFunction()) {
            jsonObject.add("fun", (JsonElement)new JsonPrimitive(value.getFunction().getId()));
        } else if (value.getValue() == null) {
            jsonObject.add("null", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        } else {
            ParameterTypeTools.writeToJsonInternal(jsonObject, type, value.getValue());
        }
        return jsonObject;
    }

    public static ParameterValue readFromJson(ParameterType type, JsonObject object) {
        if (object.has("var")) {
            return ParameterValue.variable(object.get("var").getAsInt());
        }
        if (object.has("fun")) {
            return ParameterValue.function(Functions.FUNCTIONS.get(object.get("fun").getAsString()));
        }
        if (object.has("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromJsonInternal(object, type);
    }

    public static void writeToNBT(NBTTagCompound tag, ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            tag.func_74768_a("varIdx", value.getVariableIndex());
        } else if (value.isFunction()) {
            tag.func_74778_a("funId", value.getFunction().getId());
        } else if (value.getValue() == null) {
            tag.func_74757_a("null", true);
        } else {
            ParameterTypeTools.writeToNBTInternal(tag, type, value.getValue());
        }
    }

    public static ParameterValue readFromNBT(NBTTagCompound tag, ParameterType type) {
        if (tag.func_74764_b("varIdx")) {
            return ParameterValue.variable(tag.func_74762_e("varIdx"));
        }
        if (tag.func_74764_b("funId")) {
            return ParameterValue.function(Functions.FUNCTIONS.get(tag.func_74779_i("funId")));
        }
        if (tag.func_74764_b("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromNBTInternal(tag, type);
    }

    private static ParameterValue readFromNBTInternal(NBTTagCompound tag, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant(tag.func_74779_i("v"));
            }
            case PAR_INTEGER: {
                return ParameterValue.constant(tag.func_74762_e("v"));
            }
            case PAR_LONG: {
                return ParameterValue.constant(tag.func_74763_f("v"));
            }
            case PAR_FLOAT: {
                return ParameterValue.constant(Float.valueOf(tag.func_74760_g("v")));
            }
            case PAR_NUMBER: {
                if (tag.func_74764_b("v")) {
                    return ParameterValue.constant(tag.func_74762_e("v"));
                }
                if (tag.func_74764_b("l")) {
                    return ParameterValue.constant(tag.func_74763_f("l"));
                }
                if (tag.func_74764_b("f")) {
                    return ParameterValue.constant(Float.valueOf(tag.func_74760_g("f")));
                }
                if (!tag.func_74764_b("d")) break;
                return ParameterValue.constant(tag.func_74769_h("d"));
            }
            case PAR_SIDE: {
                int v = tag.func_74762_e("v");
                EnumFacing facing = v == -1 ? null : EnumFacing.values()[v];
                String node = tag.func_74779_i("node");
                return ParameterValue.constant(new BlockSide(node, facing));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant(tag.func_74767_n("v"));
            }
            case PAR_INVENTORY: {
                EnumFacing side = EnumFacing.values()[tag.func_74762_e("side")];
                String name = null;
                EnumFacing intSide = null;
                if (tag.func_74764_b("nodeName")) {
                    name = tag.func_74779_i("nodeName");
                }
                if (tag.func_74764_b("intSide")) {
                    intSide = EnumFacing.values()[tag.func_74762_e("intSide")];
                }
                return ParameterValue.constant(new Inventory(name, side, intSide));
            }
            case PAR_ITEM: {
                if (tag.func_74764_b("item")) {
                    NBTTagCompound tc = (NBTTagCompound)tag.func_74781_a("item");
                    ItemStack stack = new ItemStack(tc);
                    if (stack.func_190916_E() == 0) {
                        stack.func_190920_e(1);
                    }
                    return ParameterValue.constant(stack);
                }
                return ParameterValue.constant(ItemStack.field_190927_a);
            }
            case PAR_FLUID: {
                if (tag.func_74764_b("fluid")) {
                    NBTTagCompound tc = (NBTTagCompound)tag.func_74781_a("fluid");
                    FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tc);
                    return ParameterValue.constant(stack);
                }
                return ParameterValue.constant(null);
            }
            case PAR_EXCEPTION: {
                String code = tag.func_74779_i("code");
                return ParameterValue.constant((Object)ExceptionType.getExceptionForCode(code));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant(new Tuple(tag.func_74762_e("x"), tag.func_74762_e("y")));
            }
            case PAR_VECTOR: {
                NBTTagList array = tag.func_150295_c("vector", 10);
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (int i = 0; i < array.func_74745_c(); ++i) {
                    vector.add(ParameterTools.readFromNBT(array.func_150305_b(i)));
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return ParameterValue.constant(null);
    }

    private static void writeToNBTInternal(NBTTagCompound tag, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                tag.func_74778_a("v", (String)value);
                break;
            }
            case PAR_INTEGER: {
                tag.func_74768_a("v", ((Integer)value).intValue());
                break;
            }
            case PAR_LONG: {
                tag.func_74772_a("v", ((Long)value).longValue());
                break;
            }
            case PAR_FLOAT: {
                tag.func_74776_a("v", ((Float)value).floatValue());
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    tag.func_74768_a("v", ((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    tag.func_74772_a("l", ((Long)value).longValue());
                    break;
                }
                if (value instanceof Float) {
                    tag.func_74776_a("f", ((Float)value).floatValue());
                    break;
                }
                if (!(value instanceof Double)) break;
                tag.func_74780_a("d", ((Double)value).doubleValue());
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                tag.func_74768_a("v", side.getSide() == null ? -1 : side.getSide().ordinal());
                tag.func_74778_a("node", side.getNodeName() == null ? "" : side.getNodeName());
                break;
            }
            case PAR_BOOLEAN: {
                tag.func_74757_a("v", ((Boolean)value).booleanValue());
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                if (inv.getNodeName() != null) {
                    tag.func_74778_a("nodeName", inv.getNodeName());
                }
                tag.func_74768_a("side", inv.getSide().ordinal());
                if (inv.getIntSide() == null) break;
                tag.func_74768_a("intSide", inv.getIntSide().ordinal());
                break;
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                NBTTagCompound tc = new NBTTagCompound();
                itemStack.func_77955_b(tc);
                tag.func_74782_a("item", (NBTBase)tc);
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                NBTTagCompound fluidTc = new NBTTagCompound();
                fluidStack.writeToNBT(fluidTc);
                tag.func_74782_a("fluid", (NBTBase)fluidTc);
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                tag.func_74778_a("code", exception.getCode());
                break;
            }
            case PAR_TUPLE: {
                tag.func_74768_a("x", ((Tuple)value).getX());
                tag.func_74768_a("y", ((Tuple)value).getY());
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                NBTTagList list = new NBTTagList();
                for (Parameter p : vector) {
                    list.func_74742_a((NBTBase)ParameterTools.writeToNBT(p));
                }
                tag.func_74782_a("vector", (NBTBase)list);
            }
        }
    }

    private static void writeToJsonInternal(JsonObject object, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                object.add("v", (JsonElement)new JsonPrimitive((String)value));
                break;
            }
            case PAR_INTEGER: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                break;
            }
            case PAR_LONG: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                break;
            }
            case PAR_FLOAT: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                    break;
                }
                if (value instanceof Long) {
                    object.add("l", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                    break;
                }
                if (value instanceof Float) {
                    object.add("f", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                    break;
                }
                if (!(value instanceof Double)) break;
                object.add("d", (JsonElement)new JsonPrimitive((Number)((Double)value)));
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                if (side.getSide() != null) {
                    object.add("side", (JsonElement)new JsonPrimitive(side.getSide().func_176610_l()));
                }
                if (side.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(side.getNodeName()));
                break;
            }
            case PAR_BOOLEAN: {
                object.add("v", (JsonElement)new JsonPrimitive((Boolean)value));
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                object.add("side", (JsonElement)new JsonPrimitive(inv.getSide().func_176610_l()));
                if (inv.getIntSide() != null) {
                    object.add("intside", (JsonElement)new JsonPrimitive(inv.getIntSide().func_176610_l()));
                }
                if (inv.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(inv.getNodeName()));
                break;
            }
            case PAR_ITEM: {
                ItemStack item = (ItemStack)value;
                object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
                if (item.func_190916_E() != 1) {
                    object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
                }
                object.add("meta", (JsonElement)new JsonPrimitive((Number)item.func_77952_i()));
                if (!item.func_77942_o()) break;
                String string = item.func_77978_p().toString();
                object.add("nbt", (JsonElement)new JsonPrimitive(string));
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                object.add("fluid", (JsonElement)new JsonPrimitive(fluidStack.getFluid().getName()));
                object.add("amount", (JsonElement)new JsonPrimitive((Number)fluidStack.amount));
                if (fluidStack.tag == null) break;
                object.add("nbt", (JsonElement)new JsonPrimitive(fluidStack.tag.toString()));
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                object.add("code", (JsonElement)new JsonPrimitive(exception.getCode()));
                break;
            }
            case PAR_TUPLE: {
                object.add("x", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getX()));
                object.add("y", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getY()));
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                JsonArray array = new JsonArray();
                for (Parameter p : vector) {
                    array.add(ParameterTools.getJsonElement(p));
                }
                object.add("vector", (JsonElement)array);
            }
        }
    }

    private static ParameterValue readFromJsonInternal(JsonObject object, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant(object.get("v").getAsString());
            }
            case PAR_INTEGER: {
                return ParameterValue.constant(object.get("v").getAsInt());
            }
            case PAR_LONG: {
                return ParameterValue.constant(object.get("v").getAsLong());
            }
            case PAR_FLOAT: {
                return ParameterValue.constant(Float.valueOf(object.get("v").getAsFloat()));
            }
            case PAR_NUMBER: {
                if (object.has("v")) {
                    return ParameterValue.constant(object.get("v").getAsInt());
                }
                if (object.has("l")) {
                    return ParameterValue.constant(object.get("l").getAsLong());
                }
                if (object.has("f")) {
                    return ParameterValue.constant(Float.valueOf(object.get("f").getAsFloat()));
                }
                if (!object.has("d")) break;
                return ParameterValue.constant(object.get("d").getAsDouble());
            }
            case PAR_SIDE: {
                EnumFacing side = object.has("side") ? EnumFacing.func_176739_a((String)object.get("side").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant(new BlockSide(node, side));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant(object.get("v").getAsBoolean());
            }
            case PAR_INVENTORY: {
                EnumFacing side = EnumFacing.func_176739_a((String)object.get("side").getAsString());
                EnumFacing intSide = object.has("intside") ? EnumFacing.func_176739_a((String)object.get("intside").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant(new Inventory(node, side, intSide));
            }
            case PAR_ITEM: {
                String itemReg = object.get("item").getAsString();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemReg));
                int amount = object.has("amount") ? object.get("amount").getAsInt() : 1;
                int meta = object.get("meta").getAsInt();
                ItemStack stack = new ItemStack(item, amount, meta);
                if (object.has("nbt")) {
                    String nbt = object.get("nbt").getAsString();
                    NBTTagCompound tagCompound = null;
                    try {
                        tagCompound = JsonToNBT.func_180713_a((String)nbt);
                    }
                    catch (NBTException nBTException) {
                        // empty catch block
                    }
                    stack.func_77982_d(tagCompound);
                }
                return ParameterValue.constant(stack);
            }
            case PAR_FLUID: {
                String fluidName = object.get("fluid").getAsString();
                int amount = object.get("amount").getAsInt();
                FluidStack fluidStack = new FluidStack(FluidRegistry.getFluid((String)fluidName), amount);
                if (object.has("nbt")) {
                    String nbt = object.get("nbt").getAsString();
                    try {
                        fluidStack.tag = JsonToNBT.func_180713_a((String)nbt);
                    }
                    catch (NBTException stack) {
                        // empty catch block
                    }
                }
                return ParameterValue.constant(fluidStack);
            }
            case PAR_EXCEPTION: {
                String code = object.get("code").getAsString();
                return ParameterValue.constant((Object)ExceptionType.getExceptionForCode(code));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant(new Tuple(object.get("x").getAsInt(), object.get("y").getAsInt()));
            }
            case PAR_VECTOR: {
                JsonArray array = object.get("vector").getAsJsonArray();
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (JsonElement element : array) {
                    JsonObject job = element.getAsJsonObject();
                    ParameterType t = ParameterType.getByName(job.get("type").getAsString());
                    vector.add(Parameter.builder().type(t).value(ParameterTypeTools.readFromJson(t, job)).build());
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return null;
    }
}

