/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.grid;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import mcjty.rftoolscontrol.api.code.Opcode;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterDescription;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.Connection;
import mcjty.rftoolscontrol.logic.ParameterTools;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GridInstance {
    private final String id;
    private final Connection primaryConnection;
    private final Connection secondaryConnection;
    private final List<Parameter> parameters;

    private GridInstance(Builder builder) {
        this.id = builder.id;
        this.primaryConnection = builder.primaryConnection;
        this.secondaryConnection = builder.secondaryConnection;
        this.parameters = builder.parameters;
    }

    public String getId() {
        return this.id;
    }

    public Connection getPrimaryConnection() {
        return this.primaryConnection;
    }

    public Connection getSecondaryConnection() {
        return this.secondaryConnection;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public JsonElement getJsonElement() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("id", (JsonElement)new JsonPrimitive(this.getId()));
        if (this.primaryConnection != null) {
            jsonObject.add("primary", (JsonElement)new JsonPrimitive(this.primaryConnection.getId()));
        }
        if (this.secondaryConnection != null) {
            jsonObject.add("secondary", (JsonElement)new JsonPrimitive(this.secondaryConnection.getId()));
        }
        JsonArray array = new JsonArray();
        for (Parameter parameter : this.getParameters()) {
            array.add(ParameterTools.getJsonElement(parameter));
        }
        jsonObject.add("parameters", (JsonElement)array);
        return jsonObject;
    }

    public static GridInstance readFromJson(JsonElement element) {
        Opcode opcode;
        JsonObject gridObject = element.getAsJsonObject();
        String id = gridObject.get("id").getAsString();
        Builder builder = GridInstance.builder(id);
        if (gridObject.has("primary")) {
            String primary = gridObject.get("primary").getAsString();
            builder.primaryConnection(Connection.getConnection(primary));
        }
        if (gridObject.has("secondary")) {
            String secondary = gridObject.get("secondary").getAsString();
            builder.secondaryConnection(Connection.getConnection(secondary));
        }
        if ((opcode = Opcodes.OPCODES.get(id)) == null) {
            return null;
        }
        List<ParameterDescription> parameters = opcode.getParameters();
        JsonArray parameterArray = gridObject.get("parameters").getAsJsonArray();
        for (int i = 0; i < parameterArray.size(); ++i) {
            JsonObject parObject = parameterArray.get(i).getAsJsonObject();
            Parameter parameter = ParameterTools.readFromJson(parObject);
            if (parameter.getParameterType() != parameters.get(i).getType()) {
                builder.parameter(Parameter.builder().type(parameters.get(i).getType()).value(ParameterValue.constant(null)).build());
                continue;
            }
            builder.parameter(parameter);
        }
        return builder.build();
    }

    public NBTTagCompound writeToNBT(int x, int y) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("x", x);
        tag.func_74768_a("y", y);
        tag.func_74778_a("id", this.getId());
        if (this.primaryConnection != null) {
            tag.func_74778_a("prim", this.primaryConnection.getId());
        }
        if (this.secondaryConnection != null) {
            tag.func_74778_a("sec", this.secondaryConnection.getId());
        }
        NBTTagList parList = new NBTTagList();
        for (Parameter parameter : this.getParameters()) {
            NBTTagCompound nbt = ParameterTools.writeToNBT(parameter);
            parList.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("pars", (NBTBase)parList);
        return tag;
    }

    public static GridInstance readFromNBT(NBTTagCompound tag) {
        Opcode opcode;
        String opcodeid = tag.func_74779_i("id");
        Builder builder = GridInstance.builder(opcodeid);
        if (tag.func_74764_b("prim")) {
            builder.primaryConnection(Connection.getConnection(tag.func_74779_i("prim")));
        }
        if (tag.func_74764_b("sec")) {
            builder.secondaryConnection(Connection.getConnection(tag.func_74779_i("sec")));
        }
        if ((opcode = Opcodes.OPCODES.get(opcodeid)) == null) {
            return null;
        }
        List<ParameterDescription> parameters = opcode.getParameters();
        NBTTagList parList = tag.func_150295_c("pars", 10);
        for (int i = 0; i < parList.func_74745_c(); ++i) {
            NBTTagCompound parTag = (NBTTagCompound)parList.func_179238_g(i);
            Parameter parameter = ParameterTools.readFromNBT(parTag);
            if (parameter.getParameterType() != parameters.get(i).getType()) {
                builder.parameter(Parameter.builder().type(parameters.get(i).getType()).value(ParameterValue.constant(null)).build());
                continue;
            }
            builder.parameter(parameter);
        }
        return builder.build();
    }

    public static class Builder {
        private final String id;
        private Connection primaryConnection;
        private Connection secondaryConnection;
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        public Builder(String id) {
            this.id = id;
        }

        public Builder primaryConnection(Connection primaryConnection) {
            this.primaryConnection = primaryConnection;
            return this;
        }

        public Builder secondaryConnection(Connection secondaryConnection) {
            this.secondaryConnection = secondaryConnection;
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public GridInstance build() {
            return new GridInstance(this);
        }
    }
}

