/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.api.parameters;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.StringUtils;

public class Inventory
extends BlockSide {
    @Nullable
    private final EnumFacing intSide;

    public Inventory(@Nullable String name, @Nonnull EnumFacing side, @Nullable EnumFacing intSide) {
        super(name, side);
        this.intSide = intSide;
    }

    public String serialize() {
        return "#" + (this.hasNodeName() ? this.getNodeName() : "-") + "#" + this.getSide().func_176610_l() + "#" + (this.intSide == null ? "-" : this.intSide.func_176610_l()) + "#";
    }

    public static Inventory deserialize(String s) {
        String[] splitted = StringUtils.split((String)s, (char)'#');
        return new Inventory("-".equals(splitted[0]) ? null : splitted[0], EnumFacing.func_176739_a((String)splitted[1]), "-".equals(splitted[2]) ? null : EnumFacing.func_176739_a((String)splitted[2]));
    }

    @Override
    @Nonnull
    public EnumFacing getSide() {
        return super.getSide();
    }

    @Nullable
    public EnumFacing getIntSide() {
        return this.intSide;
    }

    @Override
    public String getStringRepresentation() {
        String s = StringUtils.left((String)this.getSide().func_176610_l().toUpperCase(), (int)1);
        if (this.getIntSide() == null) {
            s = s + "/*";
        } else {
            String is = StringUtils.left((String)this.getIntSide().func_176610_l().toUpperCase(), (int)1);
            s = s + "/" + is;
        }
        if (this.getNodeName() == null) {
            return s;
        }
        return StringUtils.left((String)this.getNodeName(), (int)6) + " " + s;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Inventory inventory = (Inventory)o;
        return this.intSide == inventory.intSide;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.intSide != null ? this.intSide.hashCode() : 0);
        return result;
    }
}

