/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.tile;

import com.google.common.collect.Lists;
import com.valkyrieofnight.et.base.tile.ETControllerEConsumer;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.applicator.IAttributeApplicator;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.manager.NBBManager;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfo;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.base.attributes.generic.AttributeForgeEnergyFixed;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class NBBContBase
extends ETControllerEConsumer {
    private boolean enabled = false;
    public static final EnumFacing[] ENERGY_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};

    public NBBContBase(int capacitorSize) {
        super(capacitorSize);
    }

    @Override
    public void updateTile() {
        super.updateTile();
        if (!this.func_145831_w().field_72995_K) {
            // empty if block
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.disableEffects();
    }

    @Override
    public void deformMultiblock() {
        this.disableEffects();
        super.deformMultiblock();
    }

    public void func_145843_s() {
        this.disableEffects();
        super.func_145843_s();
    }

    protected void disableEffects() {
        this.enabled = false;
        List<EntityPlayer> players = this.getEffected();
        Map<AttributeID, IAttributeApplicator> apps = this.getBeaconInfo().getApplicatorRegistry().getAll();
        for (EntityPlayer player : players) {
            if (!this.canPlayerGetEffects(player)) continue;
            for (AttributeID atid : apps.keySet()) {
                if (!this.modifierHandler.hasAttribute(atid) || !this.canApplyEffect(atid, player)) continue;
                IAttributeApplicator app = apps.get(atid);
                AttributeCache cache = this.modifierHandler.getAttributeCache(atid);
                NBBManager.getInstance().getWorldData().getPlayerData(this.getOwner()).addToQueue(this.getBeaconInfo(), cache);
            }
        }
    }

    protected void updateEffects() {
        List<EntityPlayer> players = this.getEffected();
        Map<AttributeID, IAttributeApplicator> apps = this.getBeaconInfo().getApplicatorRegistry().getAll();
        for (EntityPlayer player : players) {
            if (!this.canPlayerGetEffects(player)) continue;
            for (AttributeID atid : apps.keySet()) {
                if (!this.modifierHandler.hasAttribute(atid) || !this.canApplyEffect(atid, player)) continue;
                IAttributeApplicator app = apps.get(atid);
                AttributeCache cache = this.modifierHandler.getAttributeCache(atid);
                app.onUpdateAttribute(cache, this.func_145831_w(), player);
            }
        }
    }

    protected void enableEffects() {
        this.enabled = true;
        List<EntityPlayer> players = this.getEffected();
        Map<AttributeID, IAttributeApplicator> apps = this.getBeaconInfo().getApplicatorRegistry().getAll();
        for (EntityPlayer player : players) {
            if (!this.canPlayerGetEffects(player)) continue;
            for (AttributeID atid : apps.keySet()) {
                if (!this.modifierHandler.hasAttribute(atid) || !this.canApplyEffect(atid, player)) continue;
                IAttributeApplicator app = apps.get(atid);
                AttributeCache cache = this.modifierHandler.getAttributeCache(atid);
                NBBManager.getInstance().getWorldData().getPlayerData(this.getOwner()).removeFromQueue(this.getBeaconInfo(), cache);
                app.onEnableAttribute(cache, this.func_145831_w(), player);
            }
        }
    }

    public List<ITextComponent> getInfo() {
        ArrayList rt = Lists.newArrayList();
        rt.addAll(super.getInfo());
        rt.add(new TextComponentString("FE/T: " + this.getEnergyCostPerTick()));
        return rt;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void onProcessStart() {
    }

    public void onProcessTick(int processedTicks) {
        this.eBuffer.iExtractFE(this.getEnergyCostPerTick(), false);
    }

    public void onProcessComplete() {
        if (!this.enabled) {
            this.enableEffects();
        }
        this.updateEffects();
    }

    @Override
    public boolean canProcess() {
        if (this.eBuffer.getEnergyStored() < this.getEnergyCostPerTick()) {
            return false;
        }
        return super.canProcess();
    }

    public int getEnergyCostPerTick() {
        if (this.modifierHandler.hasAttribute(AttributeForgeEnergyFixed.FORGE_ENERGY_FIXED)) {
            int e = this.getBaseEnergyCost();
            Object finalValue = this.modifierHandler.getAttributeFinalValue(AttributeForgeEnergyFixed.FORGE_ENERGY_FIXED);
            e = (Integer)AttributeForgeEnergyFixed.FORGE_ENERGY_FIXED.getCalculator().calculateModifiedValue(finalValue != null ? finalValue : Integer.valueOf(0), (Object)e);
            return e;
        }
        return 0;
    }

    public abstract int getBaseEnergyCost();

    public void onIdleTick() {
    }

    @Override
    public EnumFacing[] validEnergyDirections() {
        return ENERGY_DIRECTIONS;
    }

    public int getBaseDuration() {
        return 20;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public int modifyDuration(int unmodifiedDuration) {
        return unmodifiedDuration;
    }

    public abstract List<EntityPlayer> getEffected();

    public abstract boolean canPlayerGetEffects(EntityPlayer var1);

    public abstract boolean canApplyEffect(AttributeID var1, EntityPlayer var2);

    public abstract BeaconInfo getBeaconInfo();
}

