/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputBitStream {
    private int byteCounter;
    private int mask;
    private int currentByte;

    protected abstract int nextByte() throws IOException;

    public boolean readBit() throws IOException {
        if (this.mask == 0) {
            this.currentByte = this.nextByte();
            ++this.byteCounter;
            this.mask = 128;
        }
        boolean bit = (this.currentByte & this.mask) != 0;
        this.mask >>= 1;
        return bit;
    }

    public int bytesRead() {
        return this.byteCounter;
    }

    public static InputBitStream create(final DataInput input) {
        return new InputBitStream(){

            @Override
            protected int nextByte() throws IOException {
                return input.readByte();
            }
        };
    }

    public static InputBitStream create(final InputStream input) {
        return new InputBitStream(){

            @Override
            protected int nextByte() throws IOException {
                return input.read();
            }
        };
    }

    public static InputBitStream create(byte[] bytes) {
        return InputBitStream.create(new ByteArrayInputStream(bytes));
    }
}

