/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableDouble
extends SyncableObjectBase
implements ISyncableValueProvider<Double> {
    private double value;

    public SyncableDouble(double value) {
        this.value = value;
    }

    public SyncableDouble() {
    }

    public void set(double newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public double get() {
        return this.value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(PacketBuffer stream) {
        this.value = stream.readDouble();
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        stream.writeDouble(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74780_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74769_h(name);
    }

    public void modify(float by) {
        this.set(this.value + (double)by);
    }
}

