/*
 * Decompiled with CFR 0.152.
 */
package openmods.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.Cartesian;
import openmods.state.State;

public class StateContainer {
    private final State baseState;
    private final List<State> allStates;
    private static final Comparator<IProperty<?>> PROPERTY_NAME_COMPARATOR = (o1, o2) -> o1.func_177701_a().compareTo(o2.func_177701_a());

    public StateContainer(IProperty<?> ... properties) {
        this(Arrays.asList(properties));
    }

    public StateContainer(List<IProperty<?>> properties) {
        ArrayList sortedProperties = Lists.newArrayList(properties);
        Collections.sort(sortedProperties, PROPERTY_NAME_COMPARATOR);
        ArrayList allAlowedValues = Lists.newArrayList();
        for (IProperty property : sortedProperties) {
            allAlowedValues.add(property.func_177700_c());
        }
        HashMap valuesToStateMap = Maps.newHashMap();
        ArrayList allStates = Lists.newArrayList();
        for (List values : Cartesian.func_179321_a((Iterable)allAlowedValues)) {
            Map<IProperty<?>, Comparable<?>> propertyValueMap = StateContainer.joinLists(sortedProperties, values);
            State itemState = new State(propertyValueMap);
            allStates.add(itemState);
            valuesToStateMap.put(propertyValueMap, itemState);
        }
        for (State state : allStates) {
            state.updateNeighbours(valuesToStateMap);
        }
        this.allStates = ImmutableList.copyOf((Collection)allStates);
        this.baseState = (State)allStates.get(0);
    }

    private static Map<IProperty<?>, Comparable<?>> joinLists(List<IProperty<?>> properties, List<Comparable<?>> values) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        Iterator<IProperty<?>> keysIt = properties.iterator();
        Iterator<Comparable<?>> valuesIt = values.iterator();
        while (keysIt.hasNext() && valuesIt.hasNext()) {
            result.put(keysIt.next(), valuesIt.next());
        }
        return result.build();
    }

    public State getBaseState() {
        return this.baseState;
    }

    public List<State> getAllStates() {
        return this.allStates;
    }
}

