/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.providers;

import net.minecraft.network.PacketBuffer;
import openmods.serializable.ISerializerProvider;
import openmods.utils.io.IStreamSerializer;

public class EnumSerializerProvider
implements ISerializerProvider {
    @Override
    public IStreamSerializer<?> getSerializer(Class<?> cls) {
        return Enum.class.isAssignableFrom(cls) ? EnumSerializerProvider.createSerializer(cls) : null;
    }

    private static IStreamSerializer<?> createSerializer(final Class<?> cls) {
        Class<?> superCls = cls.getSuperclass();
        final Object[] values = superCls == Enum.class ? cls.getEnumConstants() : superCls.getEnumConstants();
        return new IStreamSerializer<Object>(){

            @Override
            public Object readFromStream(PacketBuffer input) {
                int ord = input.func_150792_a();
                try {
                    return values[ord];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ArrayIndexOutOfBoundsException(String.format("Failed to get enum with ordinal %d from class %s", ord, cls));
                }
            }

            @Override
            public void writeToStream(Object o, PacketBuffer output) {
                int ord = ((Enum)o).ordinal();
                output.func_150787_b(ord);
            }
        };
    }
}

