/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.cls;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import openmods.serializable.IObjectSerializer;
import openmods.serializable.cls.ClassSerializerBuilder;
import openmods.serializable.cls.Serialize;
import openmods.utils.CachedFactory;
import openmods.utils.FieldsSelector;

public class ClassSerializersProvider {
    public static final ClassSerializersProvider instance = new ClassSerializersProvider();
    private final CachedFactory<Class<?>, IObjectSerializer<?>> cache = new CachedFactory<Class<?>, IObjectSerializer<?>>(){

        @Override
        protected IObjectSerializer<?> create(Class<?> key) {
            ClassSerializerBuilder builder = new ClassSerializerBuilder(key);
            for (Field f : ClassSerializersProvider.this.SELECTOR.getFields(key)) {
                builder.appendField(f);
            }
            return builder.create();
        }
    };
    private final FieldsSelector SELECTOR = new FieldsSelector(){

        @Override
        protected List<FieldsSelector.FieldEntry> listFields(Class<?> cls) {
            ArrayList result = Lists.newArrayList();
            for (Field f : cls.getFields()) {
                Serialize ann = f.getAnnotation(Serialize.class);
                if (ann == null) continue;
                result.add(new FieldsSelector.FieldEntry(f, ann.rank()));
            }
            return result;
        }
    };

    public <T> IObjectSerializer<T> getSerializer(Class<? extends T> cls) {
        return this.cache.getOrCreate(cls);
    }

    public <T> IObjectSerializer<T> getSerializer(T object) {
        return this.getSerializer((T)object.getClass());
    }

    public void readFromStream(Object object, PacketBuffer input) throws IOException {
        this.getSerializer(object).readFromStream(object, input);
    }

    public void writeToStream(Object object, PacketBuffer output) throws IOException {
        this.getSerializer(object).writeToStream(object, output);
    }
}

