/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.shaders;

import com.google.common.collect.ImmutableList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import openmods.renderer.shaders.ArraysHelper;
import openmods.renderer.shaders.ShaderHelper;

public class ShaderProgram {
    private final int program;
    private final List<Integer> shaders;
    private final TObjectIntMap<String> uniforms = new ComputingObjectIntMap<String>(){

        @Override
        protected int computeValue(String key) {
            return ShaderHelper.methods().glGetUniformLocation(ShaderProgram.this.program, key);
        }
    };
    private final TObjectIntMap<String> attributes = new ComputingObjectIntMap<String>(){

        @Override
        protected int computeValue(String key) {
            return ShaderHelper.methods().glGetAttribLocation(ShaderProgram.this.program, key);
        }
    };

    ShaderProgram(int program, List<Integer> shaders) {
        this.program = program;
        this.shaders = ImmutableList.copyOf(shaders);
    }

    public void bind() {
        ShaderHelper.methods().glUseProgram(this.program);
    }

    public void release() {
        ShaderHelper.methods().glUseProgram(0);
    }

    public void destroy() {
        for (Integer shader : this.shaders) {
            ShaderHelper.methods().glDeleteShader(shader);
        }
        ShaderHelper.methods().glUseProgram(0);
        ShaderHelper.methods().glDeleteProgram(this.program);
    }

    private int getUniformLocation(String uniform) {
        return this.uniforms.get((Object)uniform);
    }

    private int getAttributeLocation(String attribute) {
        return this.attributes.get((Object)attribute);
    }

    public void uniform1i(String name, int val) {
        int location = this.getUniformLocation(name);
        if (location >= 0) {
            ShaderHelper.methods().glUniform1i(location, val);
        }
    }

    public void uniform1f(String name, float val) {
        int location = this.getUniformLocation(name);
        if (location >= 0) {
            ShaderHelper.methods().glUniform1f(location, val);
        }
    }

    public void uniform3f(String name, float x, float y, float z) {
        int location = this.getUniformLocation(name);
        if (location >= 0) {
            ShaderHelper.methods().glUniform3f(location, x, y, z);
        }
    }

    public int getProgram() {
        return this.program;
    }

    public void instanceAttributePointer(String attrib, int size, int type, boolean normalized, int stride, long offset) {
        int index = this.getAttributeLocation(attrib);
        if (index >= 0) {
            this.instanceAttributePointer(index, size, type, normalized, stride, offset);
        }
    }

    public void instanceAttributePointer(int index, int size, int type, boolean normalized, int stride, long offset) {
        this.attributePointer(index, size, type, normalized, stride, offset);
        ArraysHelper.methods().glVertexAttribDivisor(index, 1);
    }

    public void attributePointer(String attrib, int size, int type, boolean normalized, int stride, long offset) {
        int index = this.getAttributeLocation(attrib);
        if (index >= 0) {
            this.attributePointer(index, size, type, normalized, stride, offset);
        }
    }

    public void attributePointer(int index, int size, int type, boolean normalized, int stride, long offset) {
        ShaderHelper.methods().glVertexAttribPointer(index, size, type, normalized, stride, offset);
        ShaderHelper.methods().glEnableVertexAttribArray(index);
    }

    private static abstract class ComputingObjectIntMap<T>
    extends TObjectIntHashMap<T> {
        private ComputingObjectIntMap() {
        }

        public int get(Object key) {
            int index = this.index(key);
            if (index < 0) {
                Object k = key;
                int result = this.computeValue(k);
                this.put(k, result);
                return result;
            }
            return this._values[index];
        }

        protected abstract int computeValue(T var1);
    }
}

