/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import openmods.reflection.ReflectionHelper;
import openmods.reflection.ReflectionLog;

public class FieldAccess<T> {
    public final Field field;

    public FieldAccess(Field field) {
        this(field, true);
    }

    private FieldAccess(Field field, boolean log) {
        if (log) {
            ReflectionLog.logLoad(field);
        }
        this.field = field;
        field.setAccessible(true);
    }

    public T get(Object target) {
        try {
            return (T)this.field.get(target);
        }
        catch (Throwable t) {
            throw new FieldAccessException(this.field, "read", t);
        }
    }

    public void set(Object target, T value) {
        try {
            this.field.set(target, value);
        }
        catch (Throwable t) {
            throw new FieldAccessException(this.field, "set", t);
        }
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.field.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public Class<T> getType() {
        return this.field.getType();
    }

    public <C> FieldAccess<C> cast(Class<? extends C> cls) {
        Class<?> fieldType = this.field.getType();
        if (!cls.isAssignableFrom(fieldType)) {
            throw new ClassCastException(this.field + " cannot be used as field of type " + cls);
        }
        return this;
    }

    public static <T> FieldAccess<T> create(Class<?> cls, String ... names) {
        Field f = ReflectionHelper.getField(cls, names);
        return new FieldAccess<T>(f, false);
    }

    public static <T> FieldAccess<T> create(Field f) {
        return new FieldAccess<T>(f, true);
    }

    public static class FieldAccessException
    extends RuntimeException {
        private static final long serialVersionUID = 3261757597754500600L;

        private static String createMessage(Field f, String action) {
            return "Failed to " + action + " field " + f;
        }

        public FieldAccessException(Field f, String action, Throwable cause) {
            super(FieldAccessException.createMessage(f, action), cause);
        }

        public FieldAccessException(Field f, String action) {
            super(FieldAccessException.createMessage(f, action));
        }
    }
}

