/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import openmods.utils.CachedFactory;
import openmods.utils.SneakyThrower;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class ClonerFactory
implements Opcodes {
    private static final String CLONER_DESC = Type.getInternalName(ICloner.class);
    private static final Method CLONER_FUNC_DESC = Method.getMethod((java.lang.reflect.Method)ICloner.class.getDeclaredMethods()[0]);
    public static final ClonerFactory instance = new ClonerFactory();
    private final CachedFactory<Class<?>, ICloner<?>> cache = new CachedFactory<Class<?>, ICloner<?>>(){

        @Override
        protected ICloner<?> create(Class<?> key) {
            try {
                Class cls = ClonerFactory.this.createClonerClass(key);
                return (ICloner)cls.newInstance();
            }
            catch (Throwable t) {
                throw SneakyThrower.sneakyThrow(t);
            }
        }
    };
    private final ClonerClassLoader clonerClassLoader = new ClonerClassLoader();

    private static byte[] createClonerClassData(Class<?> cls) {
        ClassWriter writer = new ClassWriter(1);
        String commonCls = Type.getInternalName(cls);
        String name = commonCls + "$$cloner$";
        writer.visit(50, 4129, name, null, "java/lang/Object", new String[]{CLONER_DESC});
        writer.visitSource(".dynamic", null);
        MethodVisitor mv = writer.visitMethod(4097, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = writer.visitMethod(4097, CLONER_FUNC_DESC.getName(), CLONER_FUNC_DESC.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, commonCls);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, commonCls);
        for (Class<?> currentCls = cls; currentCls != Object.class; currentCls = currentCls.getSuperclass()) {
            ClonerFactory.addClonedFields(mv, currentCls);
        }
        mv.visitInsn(88);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static void addClonedFields(MethodVisitor writer, Class<?> currentCls) {
        String owner = Type.getType(currentCls).getInternalName();
        for (Field f : currentCls.getDeclaredFields()) {
            int modifier = f.getModifiers();
            if (Modifier.isFinal(modifier) || Modifier.isStatic(modifier) || !Modifier.isPublic(modifier)) continue;
            String fieldDesc = Type.getType(f.getType()).getDescriptor();
            writer.visitInsn(92);
            writer.visitFieldInsn(180, owner, f.getName(), fieldDesc);
            writer.visitFieldInsn(181, owner, f.getName(), fieldDesc);
        }
    }

    private Class<? extends ICloner<?>> createClonerClass(Class<?> cls) {
        byte[] classData = ClonerFactory.createClonerClassData(cls);
        return this.clonerClassLoader.define(classData);
    }

    public <T> ICloner<T> getCloner(Class<T> cls) {
        return this.cache.getOrCreate(cls);
    }

    public static interface ICloner<T> {
        public <A extends T, B extends T> void clone(A var1, B var2);
    }

    private static class ClonerClassLoader
    extends ClassLoader {
        private ClonerClassLoader() {
            super(ClonerClassLoader.class.getClassLoader());
        }

        public Class<?> define(byte[] data) {
            return this.defineClass(null, data, 0, data.length);
        }
    }
}

