/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import openmods.network.IPacketTargetSelector;

public class ExtendedOutboundHandler
extends ChannelOutboundHandlerAdapter {
    public static final AttributeKey<IPacketTargetSelector<?>> MESSAGETARGET = AttributeKey.valueOf((String)"om:outboundTarget");

    private static <T> Collection<NetworkDispatcher> getDispatchers(IPacketTargetSelector<T> target, Object arg) {
        ArrayList output = Lists.newArrayList();
        target.listDispatchers(target.castArg(arg), output);
        return output;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof FMLProxyPacket)) {
            ctx.write(msg);
            return;
        }
        Channel channel = ctx.channel();
        IPacketTargetSelector target = (IPacketTargetSelector)channel.attr(MESSAGETARGET).get();
        if (target == null) {
            ctx.write(msg);
            return;
        }
        FMLProxyPacket pkt = (FMLProxyPacket)msg;
        Side channelSide = (Side)channel.attr(NetworkRegistry.CHANNEL_SOURCE).get();
        Preconditions.checkState((boolean)target.isAllowedOnSide(channelSide), (Object)"Packet not allowed on side");
        String channelName = (String)channel.attr(NetworkRegistry.FML_CHANNEL).get();
        Object arg = channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).get();
        try {
            Collection<NetworkDispatcher> dispatchers = ExtendedOutboundHandler.getDispatchers(target, arg);
            for (NetworkDispatcher dispatcher : dispatchers) {
                dispatcher.sendProxy(pkt);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("Failed to select and send message (selector %s, arg: %s, channel: %s, side: %s)", target, arg, channelName, channelSide), t);
        }
    }

    public static void install(Map<Side, FMLEmbeddedChannel> channels) {
        for (Side side : Side.values()) {
            ExtendedOutboundHandler.install(channels.get(side));
        }
    }

    public static void install(FMLEmbeddedChannel fmlEmbeddedChannel) {
        fmlEmbeddedChannel.pipeline().addAfter("fml:outbound", "om:outbound", (ChannelHandler)new ExtendedOutboundHandler());
    }
}

