/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.misc;

import com.google.common.base.Preconditions;
import openmods.utils.render.OpenGLUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Trackball {
    private Vector3f dragStart;
    private Matrix4f lastTransform = new Matrix4f();

    private static Vector3f calculateSpherePoint(float x, float y) {
        Vector3f result = new Vector3f(x, y, 0.0f);
        float sqrZ = 1.0f - Vector3f.dot((Vector3f)result, (Vector3f)result);
        if (sqrZ > 0.0f) {
            result.z = (float)Math.sqrt(sqrZ);
        } else {
            result.normalise();
        }
        return result;
    }

    private Matrix4f getTransform(float mouseX, float mouseY) {
        Preconditions.checkNotNull((Object)this.dragStart, (Object)"Draging not started");
        Vector3f current = Trackball.calculateSpherePoint(mouseX, mouseY);
        float dot = Vector3f.dot((Vector3f)this.dragStart, (Vector3f)current);
        if ((double)Math.abs(dot - 1.0f) < 1.0E-4) {
            return this.lastTransform;
        }
        Vector3f axis = Vector3f.cross((Vector3f)this.dragStart, (Vector3f)current, null);
        try {
            axis.normalise();
        }
        catch (IllegalStateException e) {
            return this.lastTransform;
        }
        float angle = 2.0f * (float)Math.acos(dot);
        Matrix4f rotation = new Matrix4f();
        rotation.rotate(angle, axis);
        return Matrix4f.mul((Matrix4f)rotation, (Matrix4f)this.lastTransform, null);
    }

    public void applyTransform(float mouseX, float mouseY, boolean isDragging) {
        OpenGLUtils.loadMatrix(isDragging ? this.getTransform(mouseX, mouseY) : this.lastTransform);
    }

    public void startDrag(float mouseX, float mouseY) {
        this.dragStart = Trackball.calculateSpherePoint(mouseX, mouseY);
    }

    public void endDrag(float mouseX, float mouseY) {
        this.lastTransform = this.getTransform(mouseX, mouseY);
    }

    public static class TrackballWrapper {
        private final Trackball target = new Trackball();
        private final float radius;
        private final int mouseButton;
        private boolean isDragging;

        public TrackballWrapper(int mouseButton, int radiusPx) {
            this.mouseButton = mouseButton;
            this.radius = radiusPx;
        }

        public void update(int mouseX, int mouseY) {
            float mx = (float)mouseX / this.radius;
            float my = (float)mouseY / this.radius;
            boolean buttonState = Mouse.isButtonDown((int)this.mouseButton);
            if (!this.isDragging && buttonState) {
                this.isDragging = true;
                this.target.startDrag(mx, my);
            } else if (this.isDragging && !buttonState) {
                this.isDragging = false;
                this.target.endDrag(mx, my);
            }
            this.target.applyTransform(mx, my, this.isDragging);
        }

        public void setTransform(Matrix4f transform) {
            this.target.lastTransform = transform;
        }
    }
}

