/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import openmods.gui.component.GuiComponentResizableComposite;
import openmods.gui.misc.BoxRenderer;

public class GuiComponentTab
extends GuiComponentResizableComposite {
    private static final int FOLDED_WIDTH = 24;
    private static final int FOLDED_HEIGHT = 24;
    protected final int expandedWidth;
    protected final int expandedHeight;
    private boolean active = false;
    @Nonnull
    private final ItemStack iconStack;
    private double dWidth = 24.0;
    private double dHeight = 24.0;
    private int color;
    private static final BoxRenderer BOX_RENDERER = new BoxRenderer(0, 5){

        @Override
        protected void renderTopLeftCorner(Gui gui) {
        }

        @Override
        protected void renderBottomLeftCorner(Gui gui, int height) {
        }

        @Override
        protected void renderLeftEdge(Gui gui, int height) {
        }
    };

    public GuiComponentTab(int color, @Nonnull ItemStack iconStack, int expandedWidth, int expandedHeight) {
        super(-5, 0, 24, 24);
        this.expandedWidth = expandedWidth;
        this.expandedHeight = expandedHeight;
        this.iconStack = iconStack;
        this.color = color;
    }

    @Override
    protected boolean areChildrenActive() {
        return this.active && this.width == this.expandedWidth && this.height == this.expandedHeight;
    }

    @Override
    public void renderComponentBackground(int offsetX, int offsetY, int mouseX, int mouseY) {
        double targetHeight;
        double targetWidth = this.active ? (double)this.expandedWidth : 24.0;
        double d = targetHeight = this.active ? (double)this.expandedHeight : 24.0;
        if ((double)this.width != targetWidth) {
            this.dWidth += (targetWidth - this.dWidth) / 4.0;
        }
        if ((double)this.height != targetHeight) {
            this.dHeight += (targetHeight - this.dHeight) / 4.0;
        }
        this.width = (int)Math.round(this.dWidth);
        this.height = (int)Math.round(this.dHeight);
        this.bindComponentsSheet();
        BOX_RENDERER.render(this, offsetX + this.x, offsetY + this.y, this.width, this.height, this.color);
        this.drawItemStack(this.iconStack, offsetX + this.x + 3, offsetY + this.y + 3);
    }

    public boolean isOrigin(int x, int y) {
        return x < 24 && y < 24;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

