/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import openmods.gui.Icon;
import openmods.gui.component.GuiComponentResizableComposite;
import openmods.gui.misc.BoxRenderer;
import openmods.gui.misc.ISlotBackgroundRenderer;
import openmods.utils.render.RenderUtils;

public class GuiComponentPanel
extends GuiComponentResizableComposite {
    private static final BoxRenderer BOX_RENDERER = new BoxRenderer(0, 5);
    public static final ISlotBackgroundRenderer normalSlot = (gui, slot) -> gui.func_73729_b(slot.field_75223_e - 1, slot.field_75221_f - 1, 0, 20, 18, 18);
    public static final ISlotBackgroundRenderer bigSlot = (gui, slot) -> gui.func_73729_b(slot.field_75223_e - 5, slot.field_75221_f - 5, 29, 20, 26, 26);
    public static final ISlotBackgroundRenderer noRenderSlot = (gui, slot) -> {};
    private final Map<Integer, ISlotBackgroundRenderer> slotRenderers = Maps.newHashMap();
    private final Container container;

    public static ISlotBackgroundRenderer coloredSlot(int color) {
        return (gui, slot) -> {
            RenderUtils.setColor(color);
            gui.func_73729_b(slot.field_75223_e - 1, slot.field_75221_f - 1, 0, 20, 18, 18);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        };
    }

    public static ISlotBackgroundRenderer customIconSlot(Icon icon, int deltaX, int deltaY) {
        return (gui, slot) -> gui.drawSprite(icon, slot.field_75223_e + deltaX, slot.field_75221_f + deltaY);
    }

    public GuiComponentPanel(int x, int y, int width, int height, Container container) {
        super(x, y, width, height);
        this.container = container;
    }

    public void setSlotRenderer(int slotId, ISlotBackgroundRenderer renderer) {
        this.slotRenderers.put(slotId, renderer);
    }

    @Override
    protected void renderComponentBackground(int x, int y, int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindComponentsSheet();
        BOX_RENDERER.render(this, this.x + x, this.y + y, this.width, this.height, -1);
    }

    @Override
    protected void renderComponentForeground(int x, int y, int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.container != null) {
            for (Slot slot : this.container.field_75151_b) {
                this.bindComponentsSheet();
                ((ISlotBackgroundRenderer)MoreObjects.firstNonNull((Object)this.slotRenderers.get(slot.field_75222_d), (Object)normalSlot)).render(this, slot);
            }
        }
    }
}

