/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.SoundEvent;
import openmods.Sounds;
import openmods.gui.Icon;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.GuiComponentSpriteButton;
import openmods.gui.component.page.BookScaleConfig;
import openmods.gui.component.page.PageBase;
import openmods.gui.listener.IMouseDownListener;
import openmods.utils.TranslationUtils;

public class GuiComponentBook
extends BaseComposite {
    public static final Icon iconPageLeft = Icon.createSheetIcon(PageBase.BOOK_TEXTURE, 211, 0, -211, 180);
    public static final Icon iconPageRight = Icon.createSheetIcon(PageBase.BOOK_TEXTURE, 0, 0, 211, 180);
    public static final Icon iconPrev = Icon.createSheetIcon(PageBase.BOOK_TEXTURE, 57, 226, 18, 10);
    public static final Icon iconNext = Icon.createSheetIcon(PageBase.BOOK_TEXTURE, 57, 213, 18, 10);
    public static final Icon iconPrevHover = Icon.createSheetIcon(PageBase.BOOK_TEXTURE, 80, 226, 18, 10);
    public static final Icon iconNextHover = Icon.createSheetIcon(PageBase.BOOK_TEXTURE, 80, 213, 18, 10);
    private GuiComponentSpriteButton imgPrev;
    private GuiComponentSpriteButton imgNext;
    private GuiComponentLabel pageNumberLeft;
    private GuiComponentLabel pageNumberRight;
    public List<BaseComponent> pages;
    private int index = 0;

    public GuiComponentBook() {
        super(0, 0);
        GuiComponentSprite imgLeftBackground = new GuiComponentSprite(0, 0, iconPageLeft);
        GuiComponentSprite imgRightBackground = new GuiComponentSprite(0, 0, iconPageRight);
        imgRightBackground.setX(GuiComponentBook.iconPageRight.width);
        this.imgPrev = new GuiComponentSpriteButton(24, 158, iconPrev, iconPrevHover);
        this.imgPrev.setListener((BaseComponent component, int x, int y, int button) -> this.prevPage());
        this.imgNext = new GuiComponentSpriteButton(380, 158, iconNext, iconNextHover);
        this.imgNext.setListener((BaseComponent component, int x, int y, int button) -> this.nextPage());
        float scalePageNumber = BookScaleConfig.getPageNumberScale();
        this.pageNumberLeft = new GuiComponentLabel(85, 163, 100, 10, "XXX");
        this.pageNumberLeft.setScale(scalePageNumber);
        this.pageNumberRight = new GuiComponentLabel(295, 163, 100, 10, "XXX");
        this.pageNumberRight.setScale(scalePageNumber);
        this.addComponent(imgLeftBackground);
        this.addComponent(imgRightBackground);
        this.addComponent(this.imgPrev);
        this.addComponent(this.imgNext);
        this.addComponent(this.pageNumberLeft);
        this.addComponent(this.pageNumberRight);
        this.pages = Lists.newArrayList();
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    @Override
    public int getWidth() {
        return GuiComponentBook.iconPageRight.width * 2;
    }

    @Override
    public int getHeight() {
        return GuiComponentBook.iconPageRight.height;
    }

    public void addPage(BaseComponent page) {
        this.addComponent(page);
        page.setEnabled(false);
        this.pages.add(page);
    }

    public void enablePages() {
        int i = 0;
        for (BaseComponent page : this.pages) {
            boolean isRight;
            boolean isLeft = i == this.index;
            boolean bl = isRight = i == this.index + 1;
            if (isLeft) {
                page.setEnabled(true);
                page.setX(20);
            } else if (isRight) {
                page.setEnabled(true);
                page.setX(10 + GuiComponentBook.iconPageRight.width);
            } else {
                page.setEnabled(false);
            }
            ++i;
        }
        int totalPageCount = i % 2 == 0 ? i : i + 1;
        this.imgNext.setEnabled(this.index < this.pages.size() - 2);
        this.imgPrev.setEnabled(this.index > 0);
        this.pageNumberLeft.setText(TranslationUtils.translateToLocalFormatted("openmodslib.book.page", this.index + 1, totalPageCount));
        this.pageNumberRight.setText(TranslationUtils.translateToLocalFormatted("openmodslib.book.page", this.index + 2, totalPageCount));
    }

    public void changePage(int newPage) {
        if ((newPage &= 0xFFFFFFFE) != this.index) {
            this.index = newPage;
            this.enablePages();
            this.playPageTurnSound();
        }
    }

    private void playPageTurnSound() {
        this.parent.getSoundHandler().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)Sounds.PAGE_TURN, (float)1.0f));
    }

    public IMouseDownListener createBookmarkListener(int index) {
        return (component, x, y, button) -> this.changePage(index);
    }

    public void prevPage() {
        if (this.index > 0) {
            this.changePage(this.index - 2);
        }
    }

    public void nextPage() {
        if (this.index < this.pages.size() - 2) {
            this.changePage(this.index + 2);
        }
    }

    public void firstPage() {
        this.changePage(0);
    }

    public void lastPage() {
        this.changePage(this.getNumberOfPages() - 1);
    }
}

