/*
 * Decompiled with CFR 0.152.
 */
package openmods.gamelogic;

import openmods.sync.SyncableInt;

public class WorkerLogic {
    private final SyncableInt progress;
    private final int maxProgress;
    private boolean isWorking;

    public WorkerLogic(SyncableInt progress, int maxProgress) {
        this.progress = progress;
        this.maxProgress = maxProgress;
    }

    public void start() {
        this.isWorking = true;
    }

    public void pause() {
        this.isWorking = false;
    }

    public void reset() {
        this.isWorking = false;
        this.progress.set(0);
    }

    public void checkWorkCondition(boolean canWork) {
        if (this.isWorking && !canWork) {
            this.reset();
        } else if (!this.isWorking && canWork) {
            this.start();
        }
    }

    public boolean update() {
        if (this.isWorking) {
            if (this.progress.get() >= this.maxProgress) {
                this.reset();
                return true;
            }
            this.progress.modify(1);
        }
        return false;
    }

    public boolean isWorking() {
        return this.isWorking;
    }
}

