/*
 * Decompiled with CFR 0.152.
 */
package openmods.fakeplayer;

import javax.annotation.Nonnull;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import openmods.Log;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;

public class DropItemAction
implements FakePlayerPool.PlayerUser {
    private final double x;
    private final double y;
    private final double z;
    private final Vector3f v;
    private float yaw;
    private float pitch;
    @Nonnull
    private final ItemStack stack;

    public DropItemAction(@Nonnull ItemStack stack, double x, double y, double z, float vx, float vy, float vz) {
        this.stack = stack;
        this.x = x;
        this.y = y;
        this.z = z;
        this.v = new Vector3f(vx, vy, vz);
        Vector3f nv = new Vector3f();
        nv.normalize(this.v);
        this.pitch = -((float)Math.toDegrees(Math.asin(nv.y)));
        this.yaw = -((float)Math.toDegrees(Math.atan2(nv.x, nv.z)));
    }

    public DropItemAction(@Nonnull ItemStack stack, BlockPos pos, float vx, float vy, float vz) {
        this(stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), vx, vy, vz);
    }

    @Override
    public void usePlayer(OpenModsFakePlayer player) {
        player.func_70080_a(this.x, this.y - (double)player.func_70047_e(), this.z, this.yaw, this.pitch);
        EntityItem itemToDrop = new EntityItem(player.func_130014_f_(), this.x, this.y, this.z, this.stack.func_77946_l());
        itemToDrop.func_70107_b(itemToDrop.field_70165_t, itemToDrop.field_70163_u - (double)itemToDrop.field_70131_O, itemToDrop.field_70161_v);
        itemToDrop.func_174867_a(40);
        ItemTossEvent event = new ItemTossEvent(itemToDrop, (EntityPlayer)player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            Log.info("Item %s drop from this %s aborted by event", this.stack, this);
        } else {
            EntityItem droppedItem = event.getEntityItem();
            droppedItem.field_70159_w = this.v.x;
            droppedItem.field_70181_x = this.v.y;
            droppedItem.field_70179_y = this.v.z;
            player.func_130014_f_().func_72838_d((Entity)droppedItem);
        }
    }
}

