/*
 * Decompiled with CFR 0.152.
 */
package openmods.core.fixes;

import openmods.api.IResultListener;
import openmods.asm.MethodMatcher;
import openmods.asm.VisitorHelper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class HorseNullFix
extends ClassVisitor {
    private final IResultListener listener;
    private final MethodMatcher modifiedMethod;

    public HorseNullFix(String horseClass, ClassVisitor cv, IResultListener listener) {
        super(327680, cv);
        this.listener = listener;
        this.modifiedMethod = new MethodMatcher(horseClass, Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[0]).getDescriptor(), "updateHorseSlots", "func_110232_cE");
    }

    protected abstract void setFixFlag();

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.modifiedMethod.match(name, desc) ? new FixerMethodVisitor(parent) : parent;
    }

    private class FixerMethodVisitor
    extends MethodVisitor {
        public FixerMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            super.visitCode();
            String worldObjName = VisitorHelper.useSrgNames() ? "field_70170_p" : "world";
            String entityClsName = "net/minecraft/entity/Entity";
            String worldCls = Type.getObjectType((String)"net/minecraft/world/World").getDescriptor();
            this.visitVarInsn(25, 0);
            this.visitFieldInsn(180, "net/minecraft/entity/Entity", worldObjName, worldCls);
            Label skip = new Label();
            this.visitJumpInsn(199, skip);
            this.visitInsn(177);
            this.visitLabel(skip);
            HorseNullFix.this.listener.onSuccess();
            HorseNullFix.this.setFixFlag();
        }
    }

    public static class Horse
    extends HorseNullFix {
        private static boolean hasFixed;

        public Horse(String horseClass, ClassVisitor cv, IResultListener listener) {
            super(horseClass, cv, listener);
        }

        public static boolean isWorking() {
            return hasFixed;
        }

        @Override
        protected void setFixFlag() {
            hasFixed = true;
        }
    }

    public static class Llama
    extends HorseNullFix {
        private static boolean hasFixed;

        public Llama(String horseClass, ClassVisitor cv, IResultListener listener) {
            super(horseClass, cv, listener);
        }

        public static boolean isWorking() {
            return hasFixed;
        }

        @Override
        protected void setFixFlag() {
            hasFixed = true;
        }
    }

    public static class Base
    extends HorseNullFix {
        private static boolean hasFixed;

        public Base(String horseClass, ClassVisitor cv, IResultListener listener) {
            super(horseClass, cv, listener);
        }

        public static boolean isWorking() {
            return hasFixed;
        }

        @Override
        protected void setFixFlag() {
            hasFixed = true;
        }
    }
}

