/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.simpler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import openmods.config.simpler.Configurable;
import openmods.reflection.FieldAccess;
import openmods.utils.CachedFactory;
import openmods.utils.io.IStringSerializer;
import openmods.utils.io.TypeRW;

public class ConfigurableClassAdapter<T> {
    private final Class<? extends T> cls;
    private final Map<String, FieldAdapter<?>> fields;
    private static final CachedFactory<Class<?>, ConfigurableClassAdapter<?>> CACHE = new CachedFactory<Class<?>, ConfigurableClassAdapter<?>>(){

        @Override
        protected ConfigurableClassAdapter<?> create(Class<?> key) {
            return new ConfigurableClassAdapter(key);
        }
    };

    public ConfigurableClassAdapter(Class<? extends T> cls) {
        this.cls = cls;
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Field f : cls.getFields()) {
            Configurable ann = f.getAnnotation(Configurable.class);
            if (ann == null) continue;
            String name = ann.name();
            if (name.isEmpty()) {
                name = f.getName();
            }
            FieldAccess access = FieldAccess.create(f);
            IStringSerializer<?> serializer = TypeRW.getStringSerializer(f.getType());
            Preconditions.checkState((serializer != null ? 1 : 0) != 0, (String)"Can't find serializer for field %s", (Object)f);
            FieldAdapter adapter = new FieldAdapter(serializer, access);
            fields.put((Object)name, adapter);
        }
        this.fields = fields.build();
    }

    public Set<String> keys() {
        return this.fields.keySet();
    }

    private FieldAdapter<?> findField(String key) {
        FieldAdapter<?> fieldAdapter = this.fields.get(key);
        if (fieldAdapter == null) {
            throw new NoSuchPropertyException(String.format("Can't find key %s in class %s", key, this.cls));
        }
        return fieldAdapter;
    }

    public String get(T instance, String key) {
        return this.findField(key).get(instance);
    }

    public void set(T instance, String key, String value) {
        this.findField(key).set(instance, value);
    }

    public static <T> ConfigurableClassAdapter<T> getFor(Class<? extends T> cls) {
        return CACHE.getOrCreate(cls);
    }

    private static class FieldAdapter<T> {
        private final IStringSerializer<T> serializer;
        private final FieldAccess<T> access;

        public FieldAdapter(IStringSerializer<T> serializer, FieldAccess<T> access) {
            this.serializer = serializer;
            this.access = access;
        }

        public void set(Object instance, String value) {
            T converted = this.serializer.readFromString(value);
            this.access.set(instance, converted);
        }

        public String get(Object instance) {
            T value = this.access.get(instance);
            return String.valueOf(value);
        }
    }

    public static class NoSuchPropertyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSuchPropertyException(String message) {
            super(message);
        }
    }
}

