/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.fraction;

import com.google.common.collect.Ordering;
import info.openmods.calc.Calculator;
import info.openmods.calc.Environment;
import info.openmods.calc.ExprType;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.SimpleCalculatorFactory;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.executable.OperatorDictionary;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.parsing.BasicCompilerMapFactory;
import info.openmods.calc.parsing.CommonSimpleSymbolFactory;
import info.openmods.calc.parsing.IValueParser;
import info.openmods.calc.symbol.GenericFunctions;
import info.openmods.calc.symbol.NullaryFunction;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.fraction.FractionParser;
import info.openmods.calc.types.fraction.FractionPrinter;
import java.util.Random;
import org.apache.commons.lang3.math.Fraction;

public class FractionCalculatorFactory<M>
extends SimpleCalculatorFactory<Fraction, M> {
    public static final Fraction NULL_VALUE = Fraction.ZERO;
    private static final int PRIORITY_MULTIPLY = 2;
    private static final int PRIORITY_ADD = 1;
    private static final int PRIORITY_ASSIGN = 0;

    private static Fraction int2frac(int value) {
        return Fraction.getFraction((int)value, (int)1);
    }

    @Override
    protected Fraction getNullValue() {
        return NULL_VALUE;
    }

    @Override
    protected IValueParser<Fraction> getValueParser() {
        return new FractionParser();
    }

    @Override
    protected IValuePrinter<Fraction> createValuePrinter() {
        return new FractionPrinter();
    }

    @Override
    protected void configureEnvironment(Environment<Fraction> env) {
        env.setGlobalSymbol("abs", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return value.abs();
            }
        });
        env.setGlobalSymbol("sgn", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return FractionCalculatorFactory.int2frac(Integer.signum(value.getNumerator()));
            }
        });
        env.setGlobalSymbol("numerator", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return FractionCalculatorFactory.int2frac(value.getNumerator());
            }
        });
        env.setGlobalSymbol("denominator", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return FractionCalculatorFactory.int2frac(value.getDenominator());
            }
        });
        env.setGlobalSymbol("frac", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return Fraction.getFraction((int)value.getProperNumerator(), (int)value.getDenominator());
            }
        });
        env.setGlobalSymbol("int", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return FractionCalculatorFactory.int2frac(value.getProperWhole());
            }
        });
        env.setGlobalSymbol("sqrt", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return Fraction.getFraction((double)Math.sqrt(value.doubleValue()));
            }
        });
        env.setGlobalSymbol("log", (Fraction)new UnaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call(Fraction value) {
                return Fraction.getFraction((double)Math.log(value.doubleValue()));
            }
        });
        env.setGlobalSymbol("min", (Fraction)new GenericFunctions.DirectAccumulatorFunction<Fraction>(NULL_VALUE){

            @Override
            protected Fraction accumulate(Fraction result, Fraction value) {
                return (Fraction)Ordering.natural().min((Object)result, (Object)value);
            }
        });
        env.setGlobalSymbol("max", (Fraction)new GenericFunctions.DirectAccumulatorFunction<Fraction>(NULL_VALUE){

            @Override
            protected Fraction accumulate(Fraction result, Fraction value) {
                return (Fraction)Ordering.natural().max((Object)result, (Object)value);
            }
        });
        env.setGlobalSymbol("sum", (Fraction)new GenericFunctions.DirectAccumulatorFunction<Fraction>(NULL_VALUE){

            @Override
            protected Fraction accumulate(Fraction result, Fraction value) {
                return result.add(value);
            }
        });
        env.setGlobalSymbol("avg", (Fraction)new GenericFunctions.DirectAccumulatorFunction<Fraction>(NULL_VALUE){

            @Override
            protected Fraction accumulate(Fraction result, Fraction value) {
                return result.add(value);
            }

            @Override
            protected Fraction process(Fraction result, int argCount) {
                return result.multiplyBy(Fraction.getFraction((int)1, (int)argCount));
            }
        });
        final Random random = new Random();
        env.setGlobalSymbol("rand", (Fraction)new NullaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call() {
                return Fraction.getFraction((double)random.nextDouble());
            }
        });
        env.setGlobalSymbol("gauss", (Fraction)new NullaryFunction.Direct<Fraction>(){

            @Override
            protected Fraction call() {
                return Fraction.getFraction((double)random.nextGaussian());
            }
        });
    }

    @Override
    protected void configureOperators(OperatorDictionary<Operator<Fraction>> operators) {
        operators.registerOperator(new UnaryOperator.Direct<Fraction>("neg"){

            @Override
            public Fraction execute(Fraction value) {
                return value.negate();
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Fraction>("+", 1){

            @Override
            public Fraction execute(Fraction left, Fraction right) {
                return left.add(right);
            }
        });
        operators.registerOperator(new UnaryOperator.Direct<Fraction>("+"){

            @Override
            public Fraction execute(Fraction value) {
                return value;
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Fraction>("-", 1){

            @Override
            public Fraction execute(Fraction left, Fraction right) {
                return left.subtract(right);
            }
        });
        operators.registerOperator(new UnaryOperator.Direct<Fraction>("-"){

            @Override
            public Fraction execute(Fraction value) {
                return value.negate();
            }
        });
        operators.registerOperator(new BinaryOperator.Direct<Fraction>("*", 2){

            @Override
            public Fraction execute(Fraction left, Fraction right) {
                return left.multiplyBy(right);
            }
        }).setDefault();
        operators.registerOperator(new BinaryOperator.Direct<Fraction>("/", 2){

            @Override
            public Fraction execute(Fraction left, Fraction right) {
                return left.divideBy(right);
            }
        });
    }

    public static Calculator<Fraction, ExprType> createSimple() {
        return new FractionCalculatorFactory().create(new BasicCompilerMapFactory());
    }

    public static Calculator<Fraction, ExprType> createDefault() {
        final CommonSimpleSymbolFactory letFactory = new CommonSimpleSymbolFactory(0, ":", "=");
        return new FractionCalculatorFactory<ExprType>(){

            @Override
            protected void configureOperators(OperatorDictionary<Operator<Fraction>> operators) {
                super.configureOperators(operators);
                letFactory.registerSeparators(operators);
            }
        }.create(letFactory.createCompilerFactory());
    }
}

