/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.symbol;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.utils.Stack;

public abstract class UnaryFunction<E>
extends FixedCallable<E> {
    private UnaryFunction() {
        super(1, 1);
    }

    public static <E> ICallable<E> createConst(E value) {
        return new Direct<E>(){

            @Override
            protected E call(E value) {
                return value;
            }
        };
    }

    public static abstract class WithFrame<E>
    extends UnaryFunction<E> {
        protected abstract E call(Frame<E> var1, E var2);

        @Override
        public final void call(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 1);
            Stack<E> stack = executionFrame.stack();
            E value = stack.pop();
            E result = this.call(executionFrame, value);
            stack.checkIsEmpty().push(result);
        }
    }

    public static abstract class Direct<E>
    extends UnaryFunction<E> {
        protected abstract E call(E var1);

        @Override
        public final void call(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E value = stack.pop();
            E result = this.call(value);
            stack.push(result);
        }
    }
}

