/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandlerFactory;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeWriter;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.TileReader;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileWriter
extends TileNode<NetworkNodeWriter> {
    public static final TileDataParameter<String, TileWriter> CHANNEL = TileReader.createChannelParameter();

    public TileWriter() {
        this.dataManager.addWatchedParameter(CHANNEL);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        IWriter writer = (IWriter)this.getNode();
        if (facing != this.getDirection()) {
            return false;
        }
        for (IReaderWriterHandlerFactory handlerFactory : API.instance().getReaderWriterHandlerRegistry().all()) {
            if (!handlerFactory.create(null).hasCapabilityWriter(writer, capability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        T foundCapability = super.getCapability(capability, facing);
        if (foundCapability == null) {
            IWriter writer = (IWriter)this.getNode();
            if (facing != this.getDirection()) {
                return null;
            }
            Object dummyCap = null;
            for (IReaderWriterHandlerFactory handlerFactory : API.instance().getReaderWriterHandlerRegistry().all()) {
                if (!handlerFactory.create(null).hasCapabilityWriter(writer, capability)) continue;
                dummyCap = handlerFactory.create(null).getNullCapability();
            }
            if (!writer.canUpdate()) {
                return (T)dummyCap;
            }
            IReaderWriterChannel channel = writer.getNetwork().getReaderWriterManager().getChannel(writer.getChannel());
            if (channel == null) {
                return (T)dummyCap;
            }
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                foundCapability = handler.getCapabilityWriter(writer, capability);
                if (foundCapability == null) continue;
                return foundCapability;
            }
        }
        return foundCapability;
    }

    @Override
    @Nonnull
    public NetworkNodeWriter createNode(World world, BlockPos pos) {
        return new NetworkNodeWriter(world, pos);
    }

    @Override
    public String getNodeId() {
        return "writer";
    }
}

