/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.control;

import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class TabList {
    private GuiBase gui;
    private GuiBase.ElementDrawers drawers;
    private Supplier<List<IGridTab>> tabs;
    private int tabHovering;
    private int tabsPerPage;
    private Supplier<Integer> pages;
    private Supplier<Integer> page;
    private Supplier<Integer> selected;
    private boolean hadTabs;
    private List<ITabListListener> listeners = new LinkedList<ITabListListener>();
    private GuiButton left;
    private GuiButton right;
    private int width;

    public TabList(GuiBase gui, GuiBase.ElementDrawers drawers, Supplier<List<IGridTab>> tabs, Supplier<Integer> pages, Supplier<Integer> page, Supplier<Integer> selected, int tabsPerPage) {
        this.gui = gui;
        this.drawers = drawers;
        this.tabs = tabs;
        this.pages = pages;
        this.page = page;
        this.selected = selected;
        this.tabsPerPage = tabsPerPage;
    }

    public void init(int width) {
        this.width = width;
        this.left = this.gui.addButton(this.gui.getGuiLeft(), this.gui.getGuiTop() - 22, 20, 20, "<", true, this.pages.get() > 0);
        this.right = this.gui.addButton(this.gui.getGuiLeft() + width - 22, this.gui.getGuiTop() - 22, 20, 20, ">", true, this.pages.get() > 0);
    }

    public void addListener(ITabListListener listener) {
        this.listeners.add(listener);
    }

    public void drawForeground(int x, int y, int mouseX, int mouseY, boolean visible) {
        this.tabHovering = -1;
        if (visible) {
            int j = 0;
            for (int i = this.page.get() * this.tabsPerPage; i < this.page.get() * this.tabsPerPage + this.tabsPerPage; ++i) {
                if (i >= this.tabs.get().size()) continue;
                this.drawTab(this.tabs.get().get(i), true, x, y, i, j);
                if (this.gui.inBounds(x + this.getXOffset() + 29 * j, y, 28, 31 - (i == this.selected.get() ? 2 : 7), mouseX, mouseY)) {
                    this.tabHovering = i;
                }
                ++j;
            }
        }
    }

    public void update() {
        boolean hasTabs;
        boolean bl = hasTabs = !this.tabs.get().isEmpty();
        if (this.hadTabs != hasTabs) {
            this.hadTabs = hasTabs;
            this.gui.func_73866_w_();
        }
        if (this.page.get() > this.pages.get()) {
            this.listeners.forEach(t -> t.onPageChanged(this.pages.get()));
        }
        this.left.field_146125_m = this.pages.get() > 0;
        this.right.field_146125_m = this.pages.get() > 0;
        this.left.field_146124_l = this.page.get() > 0;
        this.right.field_146124_l = this.page.get() < this.pages.get();
    }

    public void drawBackground(int x, int y) {
        int j = 0;
        for (int i = this.page.get() * this.tabsPerPage; i < this.page.get() * this.tabsPerPage + this.tabsPerPage; ++i) {
            if (i >= this.tabs.get().size()) continue;
            this.drawTab(this.tabs.get().get(i), false, x, y, i, j++);
        }
    }

    public int getHeight() {
        return !this.tabs.get().isEmpty() ? 27 : 0;
    }

    private int getXOffset() {
        if (this.pages.get() > 0) {
            return 24;
        }
        return 0;
    }

    private void drawTab(IGridTab tab, boolean foregroundLayer, int x, int y, int index, int num) {
        int uvx;
        boolean isSelected;
        boolean bl = isSelected = index == this.selected.get();
        if (foregroundLayer && !isSelected || !foregroundLayer && isSelected) {
            return;
        }
        int tx = x + this.getXOffset() + 29 * num;
        int ty = y;
        GlStateManager.func_179141_d();
        this.gui.bindTexture("icons.png");
        if (!isSelected) {
            ty += 3;
        }
        int uvy = 225;
        int tbw = 28;
        int otx = tx;
        if (isSelected) {
            uvx = 227;
            if (num > 0 || this.getXOffset() != 0) {
                uvx = 226;
                uvy = 194;
                ++tbw;
                --tx;
            }
        } else {
            uvx = 199;
        }
        this.gui.drawTexture(tx, ty, uvx, uvy, tbw, 31);
        tab.drawIcon(otx + 6, ty + 9 - (!isSelected ? 3 : 0), this.drawers.getItemDrawer(), this.drawers.getFluidDrawer());
    }

    public void drawTooltip(FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (this.tabHovering >= 0 && this.tabHovering < this.tabs.get().size()) {
            this.tabs.get().get(this.tabHovering).drawTooltip(mouseX, mouseY, this.gui.getScreenWidth(), this.gui.getScreenHeight(), fontRenderer);
        }
    }

    public void mouseClicked() {
        if (this.tabHovering >= 0 && this.tabHovering < this.tabs.get().size()) {
            this.listeners.forEach(t -> t.onSelectionChanged(this.tabHovering));
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button == this.left) {
            this.listeners.forEach(t -> t.onPageChanged(this.page.get() - 1));
        } else if (button == this.right) {
            this.listeners.forEach(t -> t.onPageChanged(this.page.get() + 1));
        }
    }

    public static interface ITabListListener {
        public void onSelectionChanged(int var1);

        public void onPageChanged(int var1);
    }
}

