/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeCrafter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeCrafterManager;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.container.slot.SlotCrafterManager;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.tile.TileCrafterManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ContainerCrafterManager
extends ContainerBase {
    private IResizableDisplay display;
    private NetworkNodeCrafterManager crafterManager;
    private Map<String, Integer> containerData;
    private Map<String, IItemHandlerModifiable> dummyInventories = new HashMap<String, IItemHandlerModifiable>();
    private Map<String, Integer> headings = new HashMap<String, Integer>();
    private int rows;

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a((IContainerListener)new CrafterManagerListener(listener));
    }

    public List<IContainerListener> getListeners() {
        return this.field_75149_d;
    }

    public ContainerCrafterManager(TileCrafterManager crafterManager, EntityPlayer player, IResizableDisplay display) {
        super(crafterManager, player);
        this.display = display;
        this.crafterManager = (NetworkNodeCrafterManager)crafterManager.getNode();
        if (!player.field_70170_p.field_72995_K) {
            this.addPlayerInventory(8, display.getYPlayerInventory());
            if (((NetworkNodeCrafterManager)crafterManager.getNode()).getNetwork() != null) {
                for (Map.Entry<String, List<IItemHandlerModifiable>> entry : ((NetworkNodeCrafterManager)crafterManager.getNode()).getNetwork().getCraftingManager().getNamedContainers().entrySet()) {
                    for (IItemHandlerModifiable handler : entry.getValue()) {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            this.func_75146_a((Slot)new SlotCrafterManager((IItemHandler)handler, i, 0, 0, true, display, this.crafterManager));
                        }
                    }
                }
            }
        }
    }

    public void initSlots(@Nullable Map<String, Integer> newContainerData) {
        if (newContainerData == null) {
            if (this.containerData == null) {
                return;
            }
        } else {
            this.containerData = newContainerData;
            this.dummyInventories.clear();
        }
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.headings.clear();
        this.rows = 0;
        this.addPlayerInventory(8, this.display.getYPlayerInventory());
        int y = 37 - this.display.getCurrentOffset() * 18;
        int x = 8;
        List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(null, this.display.getSearchFieldText(), Collections.emptyList());
        for (Map.Entry<String, Integer> category : this.containerData.entrySet()) {
            Object dummy;
            if (newContainerData == null) {
                dummy = this.dummyInventories.get(category.getKey());
            } else {
                dummy = new ItemHandlerBase(category.getValue(), new Predicate[0]){

                    public int getSlotLimit(int slot) {
                        return 1;
                    }

                    @Override
                    @Nonnull
                    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                        if (NetworkNodeCrafter.isValidPatternInSlot(ContainerCrafterManager.this.getPlayer().func_130014_f_(), stack)) {
                            return super.insertItem(slot, stack, simulate);
                        }
                        return stack;
                    }
                };
                this.dummyInventories.put(category.getKey(), (IItemHandlerModifiable)dummy);
            }
            boolean foundItemsInCategory = false;
            int yHeading = y - 19;
            int slotFound = 0;
            for (int slot = 0; slot < category.getValue(); ++slot) {
                boolean visible = true;
                if (!this.display.getSearchFieldText().trim().isEmpty()) {
                    ItemStack stack = dummy.getStackInSlot(slot);
                    if (stack.func_190926_b()) {
                        visible = false;
                    } else {
                        CraftingPattern pattern = ItemPattern.getPatternFromCache(this.crafterManager.getWorld(), stack);
                        visible = false;
                        block2: for (ItemStack output : pattern.getOutputs()) {
                            GridStackItem outputConverted = new GridStackItem(output);
                            for (Predicate<IGridStack> filter : filters) {
                                if (!filter.test(outputConverted)) continue;
                                visible = true;
                                continue block2;
                            }
                        }
                    }
                }
                this.func_75146_a((Slot)new SlotCrafterManager((IItemHandler)dummy, slot, x, y, visible, this.display, this.crafterManager));
                if (!visible) continue;
                foundItemsInCategory = true;
                x += 18;
                if ((slotFound + 1) % 9 == 0 && slot + 1 < category.getValue()) {
                    x = 8;
                    y += 18;
                    ++this.rows;
                }
                ++slotFound;
            }
            if (!foundItemsInCategory) continue;
            this.headings.put(category.getKey(), yHeading);
            x = 8;
            y += 36;
            this.rows += 2;
        }
    }

    public Map<String, Integer> getHeadings() {
        return this.headings;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        if (slot.func_75216_d()) {
            stack = slot.func_75211_c();
            if (index < 36 ? !this.func_75135_a(stack, 36, this.field_75151_b.size(), false) : !this.func_75135_a(stack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public class CrafterManagerListener
    implements IContainerListener {
        private IContainerListener base;
        private boolean receivedContainerData;

        public CrafterManagerListener(IContainerListener base) {
            this.base = base;
        }

        public EntityPlayerMP getPlayer() {
            return (EntityPlayerMP)this.base;
        }

        public void func_71110_a(Container container, NonNullList<ItemStack> items) {
            if (this.receivedContainerData) {
                this.base.func_71110_a(container, items);
            }
        }

        public void func_71111_a(Container container, int slotInd, ItemStack stack) {
            if (this.receivedContainerData) {
                this.base.func_71111_a(container, slotInd, stack);
            }
        }

        public void setReceivedContainerData() {
            this.receivedContainerData = true;
        }

        public void func_71112_a(Container container, int varToUpdate, int newValue) {
            this.base.func_71112_a(container, varToUpdate, newValue);
        }

        public void func_175173_a(Container container, IInventory inventory) {
            this.base.func_175173_a(container, inventory);
        }
    }
}

