/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.ExternalStorageCacheFluid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class StorageExternalFluid
implements IStorageExternal<FluidStack> {
    private IExternalStorageContext context;
    private Supplier<IFluidHandler> handlerSupplier;
    private boolean connectedToInterface;
    private ExternalStorageCacheFluid cache = new ExternalStorageCacheFluid();

    public StorageExternalFluid(IExternalStorageContext context, Supplier<IFluidHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Nullable
    private IFluidTankProperties[] getProperties() {
        IFluidHandler handler = this.handlerSupplier.get();
        return handler != null && handler.getTankProperties() != null && handler.getTankProperties().length != 0 ? handler.getTankProperties() : null;
    }

    @Override
    public void update(INetwork network) {
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        this.cache.update(network, this.handlerSupplier.get());
    }

    @Override
    public int getCapacity() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            int cap = 0;
            for (IFluidTankProperties properties : props) {
                cap += properties.getCapacity();
            }
            return cap;
        }
        return 0;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (IFluidTankProperties properties : props) {
                FluidStack stack = properties.getContents();
                if (stack == null) continue;
                fluids.add(stack);
            }
            return fluids;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        if (this.context.acceptsFluid(stack)) {
            int filled = this.handlerSupplier.get().fill(StackUtils.copy(stack, size), action == Action.PERFORM);
            if (filled == size) {
                return null;
            }
            return StackUtils.copy(stack, size - filled);
        }
        return StackUtils.copy(stack, size);
    }

    @Override
    @Nullable
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        IFluidHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        return handler.drain(StackUtils.copy(stack, size), action == Action.PERFORM);
    }

    @Override
    public int getStored() {
        IFluidTankProperties[] props = this.getProperties();
        if (props != null) {
            int stored = 0;
            for (IFluidTankProperties properties : props) {
                FluidStack contents = properties.getContents();
                if (contents == null) continue;
                stored += contents.amount;
            }
            return stored;
        }
        return 0;
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.amount;
    }
}

