/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidDelta;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCacheListenerGridPortableFluid
implements IStorageCacheListener<FluidStack> {
    private IPortableGrid portableGrid;
    private EntityPlayerMP player;

    public StorageCacheListenerGridPortableFluid(IPortableGrid portableGrid, EntityPlayerMP player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridFluidUpdate(buf -> {
            int size = this.portableGrid.getFluidCache().getList().getStacks().size();
            buf.writeInt(size);
            for (FluidStack stack : this.portableGrid.getFluidCache().getList().getStacks()) {
                StackUtils.writeFluidStackAndHash(buf, stack);
                IStorageTracker.IStorageTrackerEntry entry = this.portableGrid.getFluidStorageTracker().get(stack);
                buf.writeBoolean(entry != null);
                if (entry != null) {
                    buf.writeLong(entry.getTime());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
                }
                buf.writeBoolean(false);
                buf.writeBoolean(false);
            }
        }, false), this.player);
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(@Nonnull FluidStack stack, int size) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridFluidDelta(null, this.portableGrid.getFluidStorageTracker(), stack, size), this.player);
    }

    @Override
    public void onChangedBulk(@Nonnull List<Pair<FluidStack, Integer>> stacks) {
        for (Pair<FluidStack, Integer> stack : stacks) {
            this.onChanged((FluidStack)stack.getLeft(), (int)((Integer)stack.getRight()));
        }
    }
}

