/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure;

import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.world.structure.WorldGenAttributeStructure;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraftforge.common.BiomeDictionary;

public class StructureTreasureShrine
extends WorldGenAttributeStructure {
    public StructureTreasureShrine() {
        super(2, 20, "treasureShrine", () -> MultiBlockArrays.treasureShrine, StructureGenBuffer.StructureType.TREASURE, true, new BiomeDictionary.Type[0]);
        this.cfgEntry.setMinY(10);
        this.cfgEntry.setMaxY(40);
        this.idealDistance = 192.0f;
    }

    @Override
    public void generate(BlockPos pos, World world, Random rand) {
        CaveAdjacencyInformation information = this.validatePosition(pos, world);
        if (information != null) {
            this.generateAsSubmergedStructure(world, pos);
            BlockPos offsetPos = pos.func_177982_a(0, 3, 0).func_177967_a(information.direction, 4);
            world.func_175698_g(offsetPos);
            world.func_175698_g(offsetPos.func_177984_a());
            IBlockState mru = BlocksAS.blockMarble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.RUNED));
            IBlockState mrw = BlocksAS.blockMarble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.RAW));
            for (int i = 0; i < information.tunnelDistance; ++i) {
                offsetPos = offsetPos.func_177972_a(information.direction);
                world.func_175698_g(offsetPos);
                world.func_175698_g(offsetPos.func_177984_a());
                world.func_175656_a(offsetPos.func_177977_b(), mrw);
                world.func_175656_a(offsetPos.func_177981_b(2), mrw);
                world.func_175656_a(offsetPos.func_177984_a().func_177972_a(information.direction.func_176746_e()), mrw);
                world.func_175656_a(offsetPos.func_177972_a(information.direction.func_176746_e()), mru);
                world.func_175656_a(offsetPos.func_177984_a().func_177972_a(information.direction.func_176735_f()), mrw);
                world.func_175656_a(offsetPos.func_177972_a(information.direction.func_176735_f()), mru);
            }
            this.getBuffer(world).markStructureGeneration(pos, StructureGenBuffer.StructureType.TREASURE);
        }
    }

    @Override
    public boolean fulfillsSpecificConditions(BlockPos pos, World world, Random random) {
        if (!this.isApplicableWorld(world)) {
            return false;
        }
        return this.isApplicableBiome(world, pos);
    }

    private boolean isApplicableWorld(World world) {
        if (this.cfgEntry.shouldIgnoreDimensionSpecifications()) {
            return true;
        }
        Integer dimId = world.field_73011_w.getDimension();
        if (this.cfgEntry.getApplicableDimensions().isEmpty()) {
            return false;
        }
        for (Integer dim : this.cfgEntry.getApplicableDimensions()) {
            if (!dim.equals(dimId)) continue;
            return true;
        }
        return false;
    }

    private boolean isApplicableBiome(World world, BlockPos pos) {
        if (this.cfgEntry.shouldIgnoreBiomeSpecifications()) {
            return true;
        }
        Biome b = world.func_180494_b(pos);
        Set types = BiomeDictionary.getTypes((Biome)b);
        if (types.isEmpty()) {
            return false;
        }
        boolean applicable = false;
        for (BiomeDictionary.Type t : types) {
            if (!this.cfgEntry.getTypes().contains(t)) continue;
            applicable = true;
        }
        return applicable;
    }

    @Override
    public BlockPos getGenerationPosition(int chX, int chZ, World world, Random rand) {
        BlockPos initial = new BlockPos(chX * 16 + 8, 0, chZ * 16 + 8);
        if (world instanceof WorldServer) {
            try {
                double zDst;
                double xDst;
                float flatDst;
                BlockPos blockpos;
                ChunkGeneratorSettings settings = ChunkGeneratorSettings.Factory.func_177865_a((String)world.func_72912_H().func_82571_y()).func_177864_b();
                if (settings.field_177833_u && (blockpos = ((WorldServer)world).func_72863_F().func_180513_a(world, "Stronghold", initial, false)) != null && (flatDst = MathHelper.func_76133_a((double)((xDst = (double)(blockpos.func_177958_n() - initial.func_177958_n())) * xDst + (zDst = (double)(blockpos.func_177952_p() - initial.func_177952_p())) * zDst))) <= 20.0f) {
                    return null;
                }
            }
            catch (Exception settings) {
                // empty catch block
            }
        }
        for (int i = 0; i < 15; ++i) {
            BlockPos pos = initial.func_177982_a(rand.nextInt(16), this.cfgEntry.getMinY() + rand.nextInt(this.cfgEntry.getMaxY() - this.cfgEntry.getMinY()), rand.nextInt(16));
            CaveAdjacencyInformation information = this.validatePosition(pos, world);
            if (information == null) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    private CaveAdjacencyInformation validatePosition(BlockPos pos, World world) {
        BlockPos.PooledMutableBlockPos move = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int xx = -4; xx <= 4; ++xx) {
            for (int zz = -4; zz <= 4; ++zz) {
                for (int yy = 0; yy <= 8; ++yy) {
                    move.func_181079_c(pos.func_177958_n() + xx, pos.func_177956_o() + yy, pos.func_177952_p() + zz);
                    IBlockState at = world.func_180495_p((BlockPos)move);
                    if (at.func_185917_h()) continue;
                    move.func_185344_t();
                    return null;
                }
            }
        }
        move.func_185344_t();
        for (EnumFacing face : EnumFacing.field_176754_o) {
            BlockPos offsetPos = pos.func_177982_a(0, 3, 0).func_177967_a(face, 4);
            for (int n = 1; n < 4; ++n) {
                BlockPos testAt = offsetPos.func_177967_a(face, n);
                if (!world.func_175623_d(testAt) || !world.func_175623_d(testAt.func_177984_a())) continue;
                return new CaveAdjacencyInformation(face, n);
            }
        }
        return null;
    }

    private static class CaveAdjacencyInformation {
        private final EnumFacing direction;
        private final int tunnelDistance;

        private CaveAdjacencyInformation(EnumFacing direction, int tunnelDistance) {
            this.direction = direction;
            this.tunnelDistance = tunnelDistance;
        }
    }
}

