/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.effect.time;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.data.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopEffectHelper;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopZone;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TimeStopController
implements ITickHandler {
    private Map<Integer, List<TimeStopZone>> activeTimeStopZones = new HashMap<Integer, List<TimeStopZone>>();
    public static TimeStopController INSTANCE = new TimeStopController();

    private TimeStopController() {
    }

    @Nullable
    public static TimeStopZone tryGetZoneAt(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return null;
        }
        int dimId = world.field_73011_w.getDimension();
        List<TimeStopZone> zones = TimeStopController.INSTANCE.activeTimeStopZones.get(dimId);
        if (zones == null || zones.isEmpty()) {
            return null;
        }
        for (TimeStopZone zone : zones) {
            if (!zone.offset.equals((Object)pos)) continue;
            return zone;
        }
        return null;
    }

    @Nullable
    public static TimeStopZone freezeWorldAt(@Nonnull TimeStopZone.EntityTargetController controller, @Nonnull World world, @Nonnull BlockPos offset, boolean reducedParticles, float range, int maxAge) {
        if (world.field_73011_w == null) {
            return null;
        }
        TimeStopZone stopZone = new TimeStopZone(controller, range, offset, world, maxAge, reducedParticles);
        int dimId = world.field_73011_w.getDimension();
        List zones = TimeStopController.INSTANCE.activeTimeStopZones.computeIfAbsent(dimId, id -> new LinkedList());
        zones.add(stopZone);
        ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_addNewEffect(dimId, TimeStopEffectHelper.fromZone(stopZone));
        return stopZone;
    }

    @SubscribeEvent
    public void onWorldClear(WorldEvent.Unload event) {
        World w = event.getWorld();
        if (w != null && w.field_73011_w != null) {
            int id = w.field_73011_w.getDimension();
            List<TimeStopZone> freezeAreas = this.activeTimeStopZones.get(id);
            if (freezeAreas != null && !freezeAreas.isEmpty()) {
                for (TimeStopZone stop : freezeAreas) {
                    stop.stopEffect();
                }
            }
            ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_clearEffects(id);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingTickTest(LivingEvent.LivingUpdateEvent event) {
        int id;
        List<TimeStopZone> freezeAreas;
        World w;
        EntityLivingBase e = event.getEntityLiving();
        if (e.func_70644_a((Potion)RegistryPotions.potionTimeFreeze)) {
            boolean shouldFreeze = true;
            if (e.field_70128_L || e.func_110143_aJ() <= 0.0f) {
                shouldFreeze = false;
            }
            if (e instanceof EntityDragon && ((EntityDragon)e).func_184670_cT().func_188756_a().func_188652_i() == PhaseList.field_188750_j) {
                shouldFreeze = false;
            }
            if (shouldFreeze) {
                if (e.field_70170_p.field_72995_K && e.field_70170_p.field_73012_v.nextInt(5) == 0) {
                    TimeStopEffectHelper.playEntityParticles(e);
                }
                TimeStopZone.handleImportantEntityTicks(e);
                event.setCanceled(true);
                return;
            }
        }
        if ((w = e.field_70170_p) != null && w.field_73011_w != null && (freezeAreas = this.activeTimeStopZones.get(id = w.field_73011_w.getDimension())) != null && !freezeAreas.isEmpty()) {
            for (TimeStopZone stop : freezeAreas) {
                if (!stop.interceptEntityTick(e)) continue;
                TimeStopZone.handleImportantEntityTicks(e);
                event.setCanceled(true);
                return;
            }
        }
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        for (Map.Entry<Integer, List<TimeStopZone>> zoneMap : this.activeTimeStopZones.entrySet()) {
            Iterator<TimeStopZone> iterator = zoneMap.getValue().iterator();
            while (iterator.hasNext()) {
                TimeStopZone zone = iterator.next();
                if (zone.shouldDespawn()) {
                    zone.stopEffect();
                    ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_removeEffect(zoneMap.getKey(), TimeStopEffectHelper.fromZone(zone));
                    iterator.remove();
                    continue;
                }
                zone.onServerTick();
                if (!zone.shouldDespawn()) continue;
                zone.stopEffect();
                ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_removeEffect(zoneMap.getKey(), TimeStopEffectHelper.fromZone(zone));
                iterator.remove();
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase.equals((Object)TickEvent.Phase.START);
    }

    @Override
    public String getName() {
        return "TimeStop Controller";
    }
}

