/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.network;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectCollector;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXBurst;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionSourceNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.IndependentCrystalSource;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.IStructureAreaOfInfluence;
import hellfirepvp.astralsorcery.common.tile.base.TileSourceBase;
import hellfirepvp.astralsorcery.common.util.PatternMatchHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCollectorCrystal
extends TileSourceBase
implements IMultiblockDependantTile,
IStructureAreaOfInfluence {
    public static final BlockPos[] offsetsLiquidStarlight = new BlockPos[]{new BlockPos(-1, -4, -1), new BlockPos(0, -4, -1), new BlockPos(1, -4, -1), new BlockPos(1, -4, 0), new BlockPos(1, -4, 1), new BlockPos(0, -4, 1), new BlockPos(-1, -4, 1), new BlockPos(-1, -4, 0)};
    private static final Random rand = new Random();
    private ChangeSubscriber<StructureMatcherPatternArray> structureMatch = null;
    private BlockCollectorCrystalBase.CollectorCrystalType type;
    private CrystalProperties usedCrystalProperties;
    private boolean playerMade;
    private boolean multiBlockPresent = false;
    private IWeakConstellation associatedType;
    private IMinorConstellation associatedTrait;
    private Object[] orbitals = new Object[4];

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksExisted > 4 && this.associatedType == null && !this.func_145831_w().func_175698_g(this.func_174877_v())) {
                return;
            }
            if (this.type == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL) {
                boolean found;
                boolean update;
                if (this.structureMatch == null) {
                    this.structureMatch = PatternMatchHelper.getOrCreateMatcher(this.func_145831_w(), this.func_174877_v(), this.getRequiredStructure());
                }
                boolean bl = update = this.multiBlockPresent != (found = this.structureMatch.matches(this.func_145831_w()));
                if (update) {
                    this.multiBlockPresent = found;
                    this.setEnhanced(found);
                    this.markForUpdate();
                }
            }
        } else if (!this.doesSeeSky()) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            p.motion(rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.04f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.2f).setMaxAge(35);
            if (this.type == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL) {
                p.setColor(Color.CYAN);
            } else {
                p.setColor(Color.WHITE);
            }
        } else if (this.isEnhanced() && this.type == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL && this.associatedType != null) {
            this.playEnhancedEffects();
        }
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        if (this.type == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL) {
            return MultiBlockArrays.patternCollectorEnhancement;
        }
        return null;
    }

    @Override
    @Nonnull
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    @SideOnly(value=Side.CLIENT)
    private void playEnhancedEffects() {
        Color c;
        if (Minecraft.func_71375_t()) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            p.motion(rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.25f).setColor(Color.CYAN).setMaxAge(25);
        }
        for (int i = 0; i < this.orbitals.length; ++i) {
            OrbitalEffectController ctrl = (OrbitalEffectController)this.orbitals[i];
            if (ctrl == null) {
                OrbitalEffectCollector prop = new OrbitalEffectCollector(this);
                ctrl = EffectHandler.getInstance().orbital(prop, null, null);
                ctrl.setOffset(new Vector3(this).add(0.5, 0.5, 0.5));
                ctrl.setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.4);
                ctrl.setOrbitAxis(Vector3.random());
                ctrl.setTicksPerRotation(60);
                this.orbitals[i] = ctrl;
                continue;
            }
            if (!ctrl.canRemove() && !ctrl.isRemoved()) continue;
            this.orbitals[i] = null;
        }
        BlockPos randomPos = offsetsLiquidStarlight[rand.nextInt(offsetsLiquidStarlight.length)].func_177971_a((Vec3i)this.field_174879_c);
        Vector3 from = new Vector3(randomPos).add(rand.nextFloat(), 0.8, rand.nextFloat());
        Vector3 to = new Vector3(this).add(0.5, 0.5, 0.5);
        Vector3 mov = to.clone().subtract(from).normalize().multiply(0.1);
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(from.getX(), from.getY(), from.getZ());
        p.motion(mov.getX(), mov.getY(), mov.getZ()).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        p.gravity(0.004).scale(0.25f).setMaxAge(30 + rand.nextInt(10));
        switch (rand.nextInt(4)) {
            case 0: {
                c = Color.WHITE;
                break;
            }
            case 1: {
                c = this.associatedType.getConstellationColor().brighter();
                break;
            }
            default: {
                c = this.associatedType.getConstellationColor();
            }
        }
        p.setColor(c);
        if (this.usedCrystalProperties != null && (this.usedCrystalProperties.getPurity() > 90 || this.usedCrystalProperties.getCollectiveCapability() > 90) && rand.nextInt(100) == 0) {
            AstralSorcery.proxy.fireLightning(this.field_145850_b, to, from, c);
        }
    }

    @Override
    public boolean onSelect(EntityPlayer player) {
        if (player.func_70093_af()) {
            for (BlockPos linkTo : Lists.newArrayList(this.getLinkedPositions())) {
                this.tryUnlink(player, linkTo);
            }
            player.func_145747_a(new TextComponentTranslation("misc.link.unlink.all", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Color getEffectRenderColor() {
        return this.providesEffect() ? Color.WHITE : null;
    }

    @Override
    public double getRadius() {
        return this.providesEffect() ? 16.0 : 0.0;
    }

    @Override
    public boolean providesEffect() {
        return this.doesSeeSky();
    }

    @Override
    public int getDimensionId() {
        return this.func_145831_w().field_73011_w.getDimension();
    }

    public boolean isPlayerMade() {
        return this.playerMade;
    }

    public CrystalProperties getCrystalProperties() {
        return this.usedCrystalProperties;
    }

    public IWeakConstellation getConstellation() {
        return this.associatedType;
    }

    public IMinorConstellation getTrait() {
        return this.associatedTrait;
    }

    public void onPlace(IWeakConstellation constellation, @Nullable IMinorConstellation trait, CrystalProperties properties, boolean player, BlockCollectorCrystalBase.CollectorCrystalType type) {
        this.associatedType = constellation;
        this.associatedTrait = trait;
        this.playerMade = player;
        this.usedCrystalProperties = properties;
        this.type = type;
        this.needsUpdate = true;
        this.func_70296_d();
    }

    public void setEnhanced(boolean enhanced) {
        if (!this.field_145850_b.field_72995_K && this.type == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL) {
            this.multiBlockPresent = enhanced;
            WorldNetworkHandler handle = WorldNetworkHandler.getNetworkHandler(this.field_145850_b);
            IIndependentStarlightSource source = handle.getSourceAt(this.func_174877_v());
            if (source != null && source instanceof IndependentCrystalSource) {
                ((IndependentCrystalSource)source).setEnhanced(enhanced);
                handle.markDirty();
            }
            this.markForUpdate();
        }
    }

    public boolean isEnhanced() {
        return this.multiBlockPresent;
    }

    @SideOnly(value=Side.CLIENT)
    public static void breakParticles(PktParticleEvent event) {
        BlockPos at = event.getVec().toBlockPos();
        EffectHandler.getInstance().registerFX(new EntityFXBurst((double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, 3.0f));
    }

    public static void breakDamage(World world, BlockPos pos) {
    }

    public BlockCollectorCrystalBase.CollectorCrystalType getType() {
        return this.type;
    }

    @Override
    public boolean hasBeenLinked() {
        return !this.playerMade;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.playerMade = compound.func_74767_n("player");
        this.associatedType = (IWeakConstellation)IConstellation.readFromNBT(compound);
        this.associatedTrait = (IMinorConstellation)IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey() + "trait");
        this.usedCrystalProperties = CrystalProperties.readFromNBT(compound);
        this.type = BlockCollectorCrystalBase.CollectorCrystalType.values()[compound.func_74762_e("collectorType")];
        this.multiBlockPresent = compound.func_74764_b("enhanced") ? compound.func_74767_n("enhanced") : compound.func_74767_n("multiBlockPresent");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("player", this.playerMade);
        if (this.associatedType != null) {
            this.associatedType.writeToNBT(compound);
        }
        if (this.associatedTrait != null) {
            this.associatedTrait.writeToNBT(compound, IConstellation.getDefaultSaveKey() + "trait");
        }
        if (this.usedCrystalProperties != null) {
            this.usedCrystalProperties.writeToNBT(compound);
        }
        if (this.type != null) {
            compound.func_74768_a("collectorType", this.type.ordinal());
        }
        compound.func_74757_a("multiBlockPresent", this.multiBlockPresent);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return Block.field_185505_j.func_186662_g(1.0).func_186670_a(this.func_174877_v());
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockcollectorcrystal.name";
    }

    @Override
    @Nonnull
    public IIndependentStarlightSource provideNewSourceNode() {
        return new IndependentCrystalSource(this.usedCrystalProperties, this.associatedType, this.doesSeeSky, this.hasBeenLinked(), this.type);
    }

    @Override
    @Nonnull
    public ITransmissionSource provideSourceNode(BlockPos at) {
        return new SimpleTransmissionSourceNode(at);
    }
}

