/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalPropertiesInfuser;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.auxiliary.LiquidStarlightChaliceHandler;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.IGatedRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.ActiveInfusionTask;
import hellfirepvp.astralsorcery.common.crafting.infusion.InfusionRecipeRegistry;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.item.base.IWandInteract;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBase;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.PatternMatchHelper;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileStarlightInfuser
extends TileReceiverBase
implements IWandInteract,
IMultiblockDependantTile {
    public static final BlockPos[] offsetsLiquidStarlight = new BlockPos[]{new BlockPos(-2, -1, -1), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, 1), new BlockPos(2, -1, -1), new BlockPos(2, -1, 0), new BlockPos(2, -1, 1), new BlockPos(-1, -1, -2), new BlockPos(0, -1, -2), new BlockPos(1, -1, -2), new BlockPos(-1, -1, 2), new BlockPos(0, -1, 2), new BlockPos(1, -1, 2)};
    private ActiveInfusionTask craftingTask = null;
    private Object clientOrbitalCrafting = null;
    private Object clientOrbitalCraftingMirror = null;
    private ItemStack stack = ItemStack.field_190927_a;
    private ChangeSubscriber<StructureMatcherPatternArray> structureMatch = null;
    private boolean hasMultiblock = false;
    private boolean doesSeeSky = false;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.ticksExisted & 0xF) == 0) {
            this.updateSkyState();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateMultiblockState();
            if (this.doTryCraft()) {
                this.markForUpdate();
            }
        } else if (this.craftingTask != null) {
            this.doClientCraftEffects();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doClientCraftEffects() {
        OrbitalEffectController ctrl;
        OrbitalPropertiesInfuser prop;
        this.craftingTask.getRecipeToCraft().onCraftClientTick(this, ClientScheduler.getClientTick(), rand);
        if (this.clientOrbitalCrafting == null || ((OrbitalEffectController)this.clientOrbitalCrafting).isRemoved()) {
            prop = new OrbitalPropertiesInfuser(this, false);
            ctrl = EffectHandler.getInstance().orbital(prop, prop, null);
            ctrl.setOffset(new Vector3(this).add(0.5, 0.0, 0.5));
            ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS);
            ctrl.setOrbitRadius(2.0);
            ctrl.setTicksPerRotation(80);
            this.clientOrbitalCrafting = ctrl;
        }
        if (this.clientOrbitalCraftingMirror == null || ((OrbitalEffectController)this.clientOrbitalCraftingMirror).isRemoved()) {
            prop = new OrbitalPropertiesInfuser(this, true);
            ctrl = EffectHandler.getInstance().orbital(prop, prop, null);
            ctrl.setOffset(new Vector3(this).add(0.5, 0.0, 0.5));
            ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS);
            ctrl.setTicksPerRotation(80);
            ctrl.setTickOffset(ctrl.getMaxAge() / 2);
            ctrl.setOrbitRadius(2.0);
            this.clientOrbitalCraftingMirror = ctrl;
        }
        Vector3 target = new Vector3(this).add(0.5, 0.8, 0.5);
        for (BlockPos bp : this.craftingTask.getPendingChalicePositions()) {
            for (int i = 0; i < 4; ++i) {
                Vector3 from = new Vector3(bp).add(-0.2 + (double)rand.nextFloat() * 1.4, 1.1 + (double)rand.nextFloat() * 1.4, -0.2 + (double)rand.nextFloat() * 1.4);
                Vector3 mov = target.clone().subtract(from).normalize().multiply(0.05 + 0.05 * (double)rand.nextFloat());
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(from.getX(), from.getY(), from.getZ());
                p.motion(mov.getX(), mov.getY(), mov.getZ()).setMaxAge(30 + rand.nextInt(25));
                p.gravity(0.004).scale(0.25f).setColor(Color.WHITE);
                if (rand.nextInt(4) != 0) continue;
                p.setColor(IConstellation.major);
            }
        }
    }

    private boolean doTryCraft() {
        if (this.craftingTask == null) {
            return false;
        }
        AbstractInfusionRecipe altarRecipe = this.craftingTask.getRecipeToCraft();
        if (!altarRecipe.matches(this)) {
            this.abortCrafting();
            return true;
        }
        if (this.craftingTask.isFinished()) {
            this.finishCrafting();
            return true;
        }
        boolean changed = false;
        if (this.craftingTask.tick(this)) {
            changed = true;
        }
        this.craftingTask.getRecipeToCraft().onCraftServerTick(this, this.craftingTask.getTicksCrafting(), rand);
        return changed;
    }

    private void finishCrafting() {
        if (this.craftingTask == null) {
            return;
        }
        AbstractInfusionRecipe altarRecipe = this.craftingTask.getRecipeToCraft();
        ItemStack out = altarRecipe.getOutput(this);
        if (!out.func_190926_b()) {
            out = ItemUtils.copyStackWithSize(out, out.func_190916_E());
        }
        if (altarRecipe.mayDeleteInput(this)) {
            this.stack = ItemStack.field_190927_a;
        } else {
            altarRecipe.handleInputDecrement(this);
        }
        if (!out.func_190926_b() && out.func_190916_E() > 0) {
            ItemUtils.dropItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.5, out).func_174873_u();
        }
        int size = offsetsLiquidStarlight.length;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            indexes.add(i);
        }
        Collections.shuffle(indexes);
        while (size > 0) {
            BlockPos offset = offsetsLiquidStarlight[(Integer)indexes.get(size - 1)];
            --size;
            if (!(this.field_145850_b.field_73012_v.nextFloat() < this.craftingTask.getRecipeToCraft().getLiquidStarlightConsumptionChance())) continue;
            if (!this.craftingTask.getSupportingChalices().isEmpty()) {
                TileChalice tc = this.craftingTask.getSupportingChalices().get(rand.nextInt(this.craftingTask.getSupportingChalices().size()));
                if (tc != null) {
                    tc.getTank().drain(new FluidStack(BlocksAS.fluidLiquidStarlight, 400), true);
                    tc.markForUpdate();
                }
            } else {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177971_a((Vec3i)offset));
            }
            EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
            if (altarRecipe.doesConsumeMultiple()) continue;
            break;
        }
        this.craftingTask.getRecipeToCraft().onCraftServerFinish(this, rand);
        ResearchManager.informCraftingInfusionCompletion(this, this.craftingTask);
        SoundHelper.playSoundAround((SoundEvent)Sounds.craftFinish, this.field_145850_b, (Vec3i)this.func_174877_v(), 1.0f, 1.7f);
        EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
        this.craftingTask = null;
    }

    private void updateMultiblockState() {
        boolean found;
        boolean update;
        if (this.structureMatch == null) {
            this.structureMatch = PatternMatchHelper.getOrCreateMatcher(this.func_145831_w(), this.func_174877_v(), this.getRequiredStructure());
        }
        boolean bl = update = this.hasMultiblock != (found = this.structureMatch.matches(this.func_145831_w()));
        if (update) {
            this.hasMultiblock = found;
            this.markForUpdate();
        }
    }

    private void updateSkyState() {
        boolean seesSky = this.field_145850_b.func_175678_i(this.func_174877_v());
        boolean update = this.doesSeeSky != seesSky;
        this.doesSeeSky = seesSky;
        if (update) {
            this.markForUpdate();
        }
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return MultiBlockArrays.patternStarlightInfuser;
    }

    @Override
    @Nonnull
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    @Nonnull
    public ItemStack getInputStack() {
        return this.stack;
    }

    public void setStack(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    public boolean hasMultiblock() {
        return this.hasMultiblock;
    }

    public boolean doesSeeSky() {
        return this.doesSeeSky;
    }

    private void findRecipe(EntityPlayer crafter) {
        if (this.craftingTask != null) {
            return;
        }
        AbstractInfusionRecipe recipe = InfusionRecipeRegistry.findMatchingRecipe(this);
        if (recipe instanceof IGatedRecipe && !((IGatedRecipe)((Object)recipe)).hasProgressionServer(crafter)) {
            return;
        }
        if (recipe != null) {
            this.craftingTask = new ActiveInfusionTask(recipe, crafter.func_110124_au());
            this.craftingTask.addChalices(LiquidStarlightChaliceHandler.findNearbyChalicesThatContain(this, new FluidStack(BlocksAS.fluidLiquidStarlight, this.craftingTask.getChaliceRequiredAmount())));
            this.markForUpdate();
        }
    }

    public void abortCrafting() {
        this.craftingTask = null;
        this.markForUpdate();
    }

    public ActiveInfusionTask getCraftingTask() {
        return this.craftingTask;
    }

    @SideOnly(value=Side.CLIENT)
    public OrbitalEffectController getClientOrbitalCrafting() {
        if (this.clientOrbitalCrafting == null) {
            return null;
        }
        return (OrbitalEffectController)this.clientOrbitalCrafting;
    }

    @SideOnly(value=Side.CLIENT)
    public OrbitalEffectController getClientOrbitalCraftingMirror() {
        if (this.clientOrbitalCraftingMirror == null) {
            return null;
        }
        return (OrbitalEffectController)this.clientOrbitalCraftingMirror;
    }

    public boolean canCraft() {
        return this.hasMultiblock() && !this.func_145837_r() && this.doesSeeSky();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.stack = NBTHelper.getStack(compound, "stack");
        this.hasMultiblock = compound.func_74767_n("mbState");
        this.doesSeeSky = compound.func_74767_n("seesSky");
        boolean wasNull = this.craftingTask == null;
        this.craftingTask = null;
        if (compound.func_74764_b("recipeId") && compound.func_74764_b("recipeTick")) {
            int recipeId = compound.func_74762_e("recipeId");
            AbstractInfusionRecipe recipe = InfusionRecipeRegistry.getRecipe(recipeId);
            if (recipe == null) {
                AstralSorcery.log.info("Recipe with unknown/invalid ID found: " + recipeId + " for Starlight Infuser at " + this.func_174877_v());
            } else {
                UUID uuidCraft = compound.func_186857_a("crafterUUID");
                int tick = compound.func_74762_e("recipeTick");
                NBTTagList tl = compound.func_150295_c("chalicePositions", 10);
                LinkedList<BlockPos> tcList = new LinkedList<BlockPos>();
                for (int i = 0; i < tl.func_74745_c(); ++i) {
                    tcList.add(NBTHelper.readBlockPosFromNBT(tl.func_150305_b(i)));
                }
                this.craftingTask = new ActiveInfusionTask(recipe, uuidCraft);
                this.craftingTask.forceTick(tick);
                this.craftingTask.addPendingChalicePositions(tcList);
            }
        }
        if (!wasNull && this.craftingTask == null) {
            this.clientOrbitalCrafting = null;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTHelper.setStack(compound, "stack", this.stack);
        compound.func_74757_a("mbState", this.hasMultiblock);
        compound.func_74757_a("seesSky", this.doesSeeSky);
        if (this.craftingTask != null) {
            compound.func_74768_a("recipeId", this.craftingTask.getRecipeToCraft().getUniqueRecipeId());
            compound.func_74768_a("recipeTick", this.craftingTask.getTicksCrafting());
            compound.func_186854_a("crafterUUID", this.craftingTask.getPlayerCraftingUUID());
            NBTTagList chalicePositions = new NBTTagList();
            for (TileChalice tc : this.craftingTask.getSupportingChalices()) {
                NBTTagCompound cmp = new NBTTagCompound();
                NBTHelper.writeBlockPosToNBT(tc.func_174877_v(), cmp);
                chalicePositions.func_74742_a((NBTBase)cmp);
            }
            compound.func_74782_a("chalicePositions", (NBTBase)chalicePositions);
        }
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockstarlightinfuser.name";
    }

    @Override
    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverStarlightInfuser(at);
    }

    public void onInteract(EntityPlayer playerIn, EnumHand heldHand, ItemStack heldItem) {
        if (!playerIn.func_130014_f_().field_72995_K) {
            if (playerIn.func_70093_af()) {
                if (!this.stack.func_190926_b()) {
                    playerIn.field_71071_by.func_191975_a(this.field_145850_b, this.stack);
                    this.stack = ItemStack.field_190927_a;
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 0.8f);
                    this.markForUpdate();
                }
            } else if (!heldItem.func_190926_b() && this.stack.func_190926_b()) {
                this.stack = ItemUtils.copyStackWithSize(heldItem, 1);
                if (!playerIn.func_184812_l_()) {
                    heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                }
                if (heldItem.func_190916_E() <= 0) {
                    playerIn.func_184611_a(heldHand, ItemStack.field_190927_a);
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 0.8f);
                this.markForUpdate();
            }
        }
    }

    @Override
    public void onInteract(World world, BlockPos pos, EntityPlayer player, EnumFacing side, boolean sneak) {
        if (!world.field_72995_K) {
            this.findRecipe(player);
        }
    }

    public static class StarlightInfuserReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public TransmissionReceiverStarlightInfuser provideEmptyNode() {
            return new TransmissionReceiverStarlightInfuser(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:TransmissionReceiverStarlightInfuser";
        }
    }

    public static class TransmissionReceiverStarlightInfuser
    extends SimpleTransmissionReceiver {
        public TransmissionReceiverStarlightInfuser(BlockPos thisPos) {
            super(thisPos);
        }

        @Override
        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
        }

        @Override
        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new StarlightInfuserReceiverProvider();
        }
    }
}

