/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.compound.CompoundEffectSphere;
import hellfirepvp.astralsorcery.client.effect.compound.CompoundGatewayShield;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.PatternMatchHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCelestialGateway
extends TileEntityTick
implements IMultiblockDependantTile,
IWorldNameable {
    private ChangeSubscriber<StructureMatcherPatternArray> structureMatch = null;
    private boolean hasMultiblock = false;
    private boolean doesSeeSky = false;
    private String display = null;
    private boolean gatewayRegistered = false;
    private Object clientSphere = null;
    private UUID placedBy;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.playEffects();
        } else {
            if ((this.ticksExisted & 0xF) == 0) {
                this.updateSkyState(this.field_145850_b.field_73011_w.func_177495_o() || this.field_145850_b.func_175678_i(this.func_174877_v().func_177984_a()));
            }
            this.updateMultiblockState();
            if (this.gatewayRegistered) {
                if (!this.hasMultiblock() || !this.doesSeeSky()) {
                    GatewayCache cache = (GatewayCache)WorldCacheManager.getOrLoadData(this.field_145850_b, WorldCacheManager.SaveKey.GATEWAY_DATA);
                    cache.removePosition(this.field_145850_b, this.field_174879_c);
                    this.gatewayRegistered = false;
                }
            } else if (this.hasMultiblock() && this.doesSeeSky()) {
                GatewayCache cache = (GatewayCache)WorldCacheManager.getOrLoadData(this.field_145850_b, WorldCacheManager.SaveKey.GATEWAY_DATA);
                cache.offerPosition(this.field_145850_b, this.field_174879_c, this.display == null ? "" : this.display);
                this.gatewayRegistered = true;
            }
        }
    }

    public boolean func_145818_k_() {
        return this.display != null && !this.display.isEmpty();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.display : "";
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentString("");
    }

    @Override
    protected void onFirstTick() {
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return MultiBlockArrays.patternCelestialGateway;
    }

    @Override
    @Nonnull
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    public void setGatewayName(String displayName) {
        this.display = displayName;
    }

    public void setPlacedBy(UUID placedBy) {
        this.placedBy = placedBy;
    }

    public UUID getPlacedBy() {
        return this.placedBy;
    }

    private void updateMultiblockState() {
        boolean matches;
        boolean update;
        if (this.structureMatch == null) {
            this.structureMatch = PatternMatchHelper.getOrCreateMatcher(this.func_145831_w(), this.func_174877_v(), this.getRequiredStructure());
        }
        boolean bl = update = this.hasMultiblock != (matches = this.structureMatch.matches(this.func_145831_w()));
        if (update) {
            this.hasMultiblock = matches;
            this.markForUpdate();
        }
    }

    private void updateSkyState(boolean seeSky) {
        boolean update;
        boolean bl = update = this.doesSeeSky != seeSky;
        if (update) {
            this.doesSeeSky = seeSky;
            this.markForUpdate();
        }
    }

    public boolean hasMultiblock() {
        return this.hasMultiblock;
    }

    public boolean doesSeeSky() {
        return this.doesSeeSky;
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects() {
        boolean prec = this.hasMultiblock && this.doesSeeSky;
        this.setupGatewayUI(prec);
        if (prec) {
            this.playFrameParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setupGatewayUI(boolean preconditionsFulfilled) {
        if (preconditionsFulfilled) {
            Vector3 sphereVec = new Vector3(this.field_174879_c).add(0.5, 1.62, 0.5);
            if (this.clientSphere == null) {
                CompoundGatewayShield sphere = new CompoundGatewayShield(sphereVec.clone(), Vector3.RotAxis.Y_AXIS, 6.0, 8, 10);
                sphere.setRemoveIfInvisible(true).setAlphaFadeDistance(4.0);
                EffectHandler.getInstance().registerFX(sphere);
                this.clientSphere = sphere;
            }
            double playerDst = Vector3.atEntityCenter((Entity)Minecraft.func_71410_x().field_71439_g).distance(sphereVec);
            if (this.clientSphere != null) {
                if (!((CompoundEffectSphere)this.clientSphere).getPosition().equals(sphereVec)) {
                    ((CompoundEffectSphere)this.clientSphere).requestRemoval();
                    CompoundGatewayShield sphere = new CompoundGatewayShield(sphereVec.clone(), Vector3.RotAxis.Y_AXIS, 6.0, 8, 10);
                    sphere.setRemoveIfInvisible(true).setAlphaFadeDistance(4.0);
                    EffectHandler.getInstance().registerFX(sphere);
                    this.clientSphere = sphere;
                }
                if (((EntityComplexFX)this.clientSphere).isRemoved() && playerDst < 5.0) {
                    EffectHandler.getInstance().registerFX((EntityComplexFX)this.clientSphere);
                }
            }
            if (playerDst < 5.5) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
            }
            if (playerDst < 2.5) {
                EffectHandler.getInstance().requestGatewayUIFor(this.field_145850_b, this.field_174879_c, sphereVec, 5.5);
            }
        } else if (this.clientSphere != null && !((EntityComplexFX)this.clientSphere).isRemoved()) {
            ((EntityComplexFX)this.clientSphere).requestRemoval();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playFrameParticles() {
        for (int i = 0; i < 2; ++i) {
            Vector3 offset = new Vector3(this.field_174879_c).add(-2.0, 0.0, -2.0);
            if (rand.nextBoolean()) {
                offset.add(5 * (rand.nextBoolean() ? 1 : 0), 0.0, rand.nextFloat() * 5.0f);
            } else {
                offset.add(rand.nextFloat() * 5.0f, 0.0, 5 * (rand.nextBoolean() ? 1 : 0));
            }
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(offset.getX(), offset.getY(), offset.getZ());
            p.gravity(0.0045).scale(0.25f + rand.nextFloat() * 0.15f).setMaxAge(40 + rand.nextInt(40));
            Color c = new Color(60, 0, 255);
            switch (rand.nextInt(4)) {
                case 0: {
                    c = Color.WHITE;
                    break;
                }
                case 1: {
                    c = new Color(6927871);
                    break;
                }
                case 2: {
                    c = new Color(30975);
                    break;
                }
            }
            p.setColor(c);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.hasMultiblock = compound.func_74767_n("mbState");
        this.doesSeeSky = compound.func_74767_n("skyState");
        this.display = compound.func_74779_i("display");
        this.placedBy = compound.func_186855_b("placer") ? compound.func_186857_a("placer") : null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("mbState", this.hasMultiblock);
        compound.func_74757_a("skyState", this.doesSeeSky);
        compound.func_74778_a("display", this.display == null ? "" : this.display);
        if (this.placedBy != null) {
            compound.func_186854_a("placer", this.placedBy);
        }
    }
}

